/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.monster;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.PungencyFruitVinesBlock;
import cn.leolezury.eternalstarlight.common.block.entity.DryingRackBlockEntity;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESLootTables;
import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownSpear;
import cn.leolezury.eternalstarlight.common.item.combat.SeedsLauncherItem;
import cn.leolezury.eternalstarlight.common.item.combat.SpearItem;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Stranghoul
extends Monster
implements NeutralMob,
OwnableEntity,
RangedAttackMob {
    private static final String TAG_HOME_POS = "home_pos";
    private static final String TAG_BABY = "baby";
    private static final String TAG_GROWTH_TICKS = "growth_ticks";
    private static final String TAG_BREED_COOLDOWN = "breed_cooldown";
    private static final String TAG_ADMIRATION_TICKS = "admiration_ticks";
    private static final String TAG_HIRER = "hirer";
    private static final String TAG_HIRED_TICKS_LEFT = "hired_ticks_left";
    private static final ResourceLocation SPEED_MODIFIER_BABY_ID = ResourceLocation.withDefaultNamespace((String)"baby");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_ID, 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    public GlobalPos homePos = GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPos.ZERO);
    private int growthTicks;
    private int breedCooldown = 24000;
    private int admirationTicks;
    private boolean makingLove = false;
    @Nullable
    private LivingEntity hirer;
    @Nullable
    private UUID hirerId;
    private int hiredTicksLeft;
    private boolean hiredEatAnim = false;
    protected static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.defineId(Stranghoul.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> BARTERING = SynchedEntityData.defineId(Stranghoul.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> HIRER_ID = SynchedEntityData.defineId(Stranghoul.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> BABY = SynchedEntityData.defineId(Stranghoul.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    @Nullable
    public LivingEntity getHirer() {
        if (this.level().isClientSide) {
            LivingEntity living;
            int id = this.getHirerId();
            Entity entity = this.level().getEntity(id);
            return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
        }
        return this.hirer;
    }

    public void setHirer(@Nullable LivingEntity hirer) {
        if (hirer != null) {
            this.hirerId = hirer.getUUID();
            if (!this.level().isClientSide) {
                this.setHirerId(hirer.getId());
            }
        } else if (!this.level().isClientSide) {
            this.setHirerId(-1);
        }
        this.hirer = hirer;
    }

    public boolean isHired() {
        return this.getHirer() != null;
    }

    public boolean isEating() {
        return (Boolean)this.getEntityData().get(EATING);
    }

    public void setEating(boolean eating) {
        this.getEntityData().set(EATING, (Object)eating);
    }

    public boolean isBartering() {
        return (Boolean)this.getEntityData().get(BARTERING);
    }

    public void setBartering(boolean bartering) {
        this.getEntityData().set(BARTERING, (Object)bartering);
    }

    public int getHirerId() {
        return (Integer)this.getEntityData().get(HIRER_ID);
    }

    public void setHirerId(int hirerId) {
        this.getEntityData().set(HIRER_ID, (Object)hirerId);
    }

    public boolean isBaby() {
        return (Boolean)this.getEntityData().get(BABY);
    }

    public void setBaby(boolean baby) {
        AttributeInstance instance;
        this.getEntityData().set(BABY, (Object)baby);
        if (!this.level().isClientSide && (instance = this.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
            instance.removeModifier(SPEED_MODIFIER_BABY.id());
            if (baby) {
                instance.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    public void setEquipmentsOnGrownUp() {
        Level level = this.level();
        if (level instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            DifficultyInstance difficulty = this.level().getCurrentDifficultyAt(this.blockPosition());
            this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
            this.populateDefaultEquipmentEnchantments(serverLevel, this.getRandom(), difficulty);
        }
    }

    public Stranghoul(EntityType<? extends Stranghoul> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(EATING, (Object)false).define(BARTERING, (Object)false).define(HIRER_ID, (Object)-1).define(BABY, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new EatGoal());
        this.goalSelector.addGoal(2, (Goal)new SeedsLauncherAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new SpearAttackGoal());
        this.goalSelector.addGoal(4, (Goal)new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new FollowHirerGoal());
        this.goalSelector.addGoal(7, (Goal)new BreedGoal(this));
        this.goalSelector.addGoal(8, (Goal)new GoToWantedItemGoal());
        this.goalSelector.addGoal(9, (Goal)new GoHomeGoal());
        this.goalSelector.addGoal(10, (Goal)new PlantCropGoal());
        this.goalSelector.addGoal(12, (Goal)new CropGoal());
        this.goalSelector.addGoal(12, (Goal)new DryRottenFleshGoal());
        this.goalSelector.addGoal(13, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f){

            public boolean canUse() {
                return super.canUse() && !Stranghoul.this.isBartering();
            }
        });
        this.goalSelector.addGoal(14, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(15, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HirerHurtByTargetGoal());
        this.targetSelector.addGoal(1, (Goal)new HirerHurtTargetGoal());
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, living -> living.getType().is(ESTags.EntityTypes.STRANGHOUL_PREYS) && !living.getType().is(ESTags.EntityTypes.STRANGHOUL_CANNOT_HUNT)));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, living -> !this.isHired() && (double)(living.getHealth() / living.getMaxHealth()) < 0.15));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        Item item = this.getMainHandItem().getItem();
        if (item instanceof SeedsLauncherItem) {
            SeedsLauncherItem launcherItem = (SeedsLauncherItem)item;
            if (this.getBoundingBox().inflate(6.0).intersects(target.getBoundingBox())) {
                projectile = this.getProjectile(this.getMainHandItem());
                launcherItem.performShooting(this.level(), (LivingEntity)this, (ItemStack)projectile, InteractionHand.MAIN_HAND);
            }
        } else {
            projectile = this.getMainHandItem().getItem();
            if (projectile instanceof SpearItem) {
                SpearItem spearItem = (SpearItem)projectile;
                ThrownSpear spear = spearItem.createSpear(this.level(), (LivingEntity)this, this.getX(), this.getEyeY() - 0.1, this.getZ(), this.getMainHandItem());
                double x = target.getX() - this.getX();
                double y = target.getY(0.3333333333333333) - spear.getY();
                double z = target.getZ() - this.getZ();
                double dist = Math.sqrt(x * x + z * z);
                spear.shoot(x, y + dist * (double)0.2f, z, 1.6f, 14 - this.level().getDifficulty().getId() * 4);
                this.level().addFreshEntity((Entity)spear);
            } else {
                ItemStack bow = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, (Item)Items.BOW));
                if (ESPlatform.INSTANCE.getLoader() == ESPlatform.Loader.NEOFORGE) {
                    bow = this.getItemInHand(this.getMainHandItem().getItem() instanceof BowItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                }
                ItemStack projectile = this.getProjectile(bow);
                AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)projectile, (float)distanceFactor, (ItemStack)bow);
                double x = target.getX() - this.getX();
                double y = target.getY(0.3333333333333333) - arrow.getY();
                double z = target.getZ() - this.getZ();
                double dist = Math.sqrt(x * x + z * z);
                arrow.shoot(x, y + dist * (double)0.2f, z, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
                this.playSound(ESSoundEvents.STRANGHOUL_SHOOT.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                this.level().addFreshEntity((Entity)arrow);
            }
        }
    }

    public ItemStack getProjectile(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item;
            Predicate predicate = weaponItem.getSupportedHeldProjectiles();
            ItemStack heldProjectile = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)predicate);
            return heldProjectile.isEmpty() ? (weaponItem instanceof SeedsLauncherItem ? ESItems.PUNGENCY_FRUIT_SEEDS.get().getDefaultInstance() : ESItems.MALARITE_ARROW.get().getDefaultInstance()) : heldProjectile;
        }
        return ItemStack.EMPTY;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.stranghoul.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.stranghoul.armor()).add(Attributes.ATTACK_DAMAGE, ESConfig.INSTANCE.mobsConfig.stranghoul.attackDamage()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.stranghoul.followRange()).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        if (random.nextFloat() < 0.3f && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, this.dyedLeatherArmor(Items.LEATHER_HELMET, random));
        }
        if (random.nextFloat() < 0.3f && this.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            this.setItemSlot(EquipmentSlot.CHEST, this.dyedLeatherArmor(Items.LEATHER_CHESTPLATE, random));
        }
        if (random.nextFloat() < 0.3f && this.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
            this.setItemSlot(EquipmentSlot.LEGS, this.dyedLeatherArmor(Items.LEATHER_LEGGINGS, random));
        }
        if (random.nextFloat() < 0.3f && this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
            this.setItemSlot(EquipmentSlot.FEET, this.dyedLeatherArmor(Items.LEATHER_BOOTS, random));
        }
        if (this.getMainHandItem().isEmpty()) {
            BuiltInRegistries.ITEM.getRandomElementOf(ESTags.Items.STRANGHOUL_CAN_USE, random).ifPresent(item -> this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(item)));
        }
    }

    private ItemStack dyedLeatherArmor(Item item, RandomSource random) {
        ItemStack stack = item.getDefaultInstance();
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(FastColor.ARGB32.lerp((float)random.nextFloat(), (int)FastColor.ARGB32.color((int)117, (int)135, (int)137), (int)FastColor.ARGB32.color((int)48, (int)55, (int)56)), true));
        return stack;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.homePos = GlobalPos.of((ResourceKey)level.getLevel().dimension(), (BlockPos)this.blockPosition());
        if (this.random.nextFloat() < 0.1f) {
            this.setBaby(true);
        }
        if (!this.isBaby()) {
            this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
            this.populateDefaultEquipmentEnchantments(level, this.getRandom(), difficulty);
        }
        this.breedCooldown = this.random.nextInt(24000, 36000);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            ItemEntity itemEntity2;
            Object serverLevel;
            Level level;
            if (this.getTarget() != null && !this.getTarget().isAlive()) {
                this.setTarget(null);
            }
            if (this.hirer == null && this.hirerId != null && (level = this.level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                Entity entity = serverLevel.getEntity(this.hirerId);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity;
                    this.hirer = livingEntity = (LivingEntity)entity;
                }
                if (this.hirer == null) {
                    this.hirerId = null;
                }
            }
            if (this.isAlive() && !this.dead && !this.hiredEatAnim && ESPlatform.INSTANCE.canEntityGrief(this.level(), (Entity)this)) {
                for (ItemEntity itemEntity2 : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(2.0, 1.0, 2.0))) {
                    if (itemEntity2.isRemoved() || itemEntity2.getItem().isEmpty() || itemEntity2.hasPickUpDelay() || itemEntity2.getOwner() == this || (!itemEntity2.getItem().is(ESTags.Items.STRANGHOUL_FOOD) || this.getOffhandItem().has(DataComponents.FOOD) || this.getOffhandItem().is(ESTags.Items.STRANGHOUL_CURRENCIES)) && (this.getTarget() != null || this.isBaby() || this.isEating() || !itemEntity2.getItem().is(ESTags.Items.STRANGHOUL_CURRENCIES) || this.getOffhandItem().is(ESTags.Items.STRANGHOUL_CURRENCIES))) continue;
                    this.spawnAtLocation(this.getOffhandItem());
                    this.setItemSlot(EquipmentSlot.OFFHAND, itemEntity2.getItem());
                    itemEntity2.discard();
                }
            }
            if (this.isBaby()) {
                ++this.growthTicks;
                if (this.growthTicks > 24000) {
                    this.growthTicks = 0;
                    this.setBaby(false);
                    this.addHappyParticles();
                    this.setEquipmentsOnGrownUp();
                }
            } else {
                --this.breedCooldown;
                this.breedCooldown = Math.max(this.breedCooldown, 0);
            }
            --this.hiredTicksLeft;
            this.hiredTicksLeft = Math.max(this.hiredTicksLeft, 0);
            if (this.hiredTicksLeft == 0) {
                this.setHirer(null);
            }
            if (this.getOffhandItem().is(ESTags.Items.STRANGHOUL_CURRENCIES) && this.getTarget() == null && (itemEntity2 = this.level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)itemEntity2;
                ++this.admirationTicks;
                if (this.admirationTicks >= 60) {
                    LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(ESLootTables.GAMEPLAY_STRANGHOUL_BARTERING);
                    ObjectArrayList items = lootTable.getRandomItems(new LootParams.Builder((ServerLevel)serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.PIGLIN_BARTER));
                    Vec3 pos = LandRandomPos.getPos((PathfinderMob)this, (int)4, (int)2);
                    List players = this.level().getNearbyPlayers(TargetingConditions.forNonCombat(), (LivingEntity)this, this.getBoundingBox().inflate(4.0));
                    players.sort(Comparator.comparingDouble(p -> p.distanceTo((Entity)this)));
                    if (!players.isEmpty()) {
                        pos = ((Player)players.getFirst()).position();
                    }
                    if (pos == null) {
                        pos = this.position();
                    }
                    for (ItemStack item : items) {
                        BehaviorUtils.throwItem((LivingEntity)this, (ItemStack)item, (Vec3)pos.add(0.0, 1.0, 0.0));
                    }
                    this.admirationTicks = 0;
                    this.getOffhandItem().consume(1, (LivingEntity)this);
                    this.swing(InteractionHand.OFF_HAND);
                }
                this.setBartering(true);
            } else {
                this.admirationTicks = 0;
                this.setBartering(false);
            }
        }
    }

    public boolean isAlliedTo(Entity entity) {
        OwnableEntity ownable;
        LivingEntity hirer = this.getHirer();
        return super.isAlliedTo(entity) || entity instanceof Stranghoul || hirer != null && (hirer.isAlliedTo(entity) || hirer == entity || entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).getOwnerUUID() != null && ownable.getOwnerUUID().equals(this.getOwnerUUID()));
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ESDataAttachments.STRANGHOUL_HIRING_COOLDOWN.getData((Entity)player) <= 0 && stack.is(ESTags.Items.STRANGHOUL_HIRING_FOOD) && !this.isHired() && !this.isBaby() && this.getTarget() == null) {
            this.setHirer((LivingEntity)player);
            ESDataAttachments.STRANGHOUL_HIRING_COOLDOWN.setData((Entity)player, ESConfig.INSTANCE.mobsConfig.stranghoul.hiringCooldown());
            this.hiredTicksLeft = 24000;
            this.hiredEatAnim = true;
            this.spawnAtLocation(this.getOffhandItem());
            this.setItemSlot(EquipmentSlot.OFFHAND, stack.copyWithCount(1));
            this.setPersistenceRequired();
            stack.consume(1, (LivingEntity)player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ESCriteriaTriggers.HIRE_STRANGHOUL.get().trigger(serverPlayer);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (stack.is(ESTags.Items.STRANGHOUL_CURRENCIES) && !this.isBaby() && this.getOffhandItem().isEmpty() && this.getTarget() == null) {
            this.setItemSlot(EquipmentSlot.OFFHAND, stack.copyWithCount(1));
            stack.consume(1, (LivingEntity)player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isHired() && player == this.getHirer()) {
            if (stack.is(ItemTags.HEAD_ARMOR)) {
                if (!this.level().isClientSide) {
                    player.setItemInHand(hand, this.getItemBySlot(EquipmentSlot.HEAD).copy());
                    this.setItemSlot(EquipmentSlot.HEAD, stack.copy());
                    this.setGuaranteedDrop(EquipmentSlot.HEAD);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (stack.is(ItemTags.CHEST_ARMOR)) {
                if (!this.level().isClientSide) {
                    player.setItemInHand(hand, this.getItemBySlot(EquipmentSlot.CHEST).copy());
                    this.setItemSlot(EquipmentSlot.CHEST, stack.copy());
                    this.setGuaranteedDrop(EquipmentSlot.CHEST);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (stack.is(ItemTags.LEG_ARMOR)) {
                if (!this.level().isClientSide) {
                    player.setItemInHand(hand, this.getItemBySlot(EquipmentSlot.LEGS).copy());
                    this.setItemSlot(EquipmentSlot.LEGS, stack.copy());
                    this.setGuaranteedDrop(EquipmentSlot.LEGS);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (stack.is(ItemTags.FOOT_ARMOR)) {
                if (!this.level().isClientSide) {
                    player.setItemInHand(hand, this.getItemBySlot(EquipmentSlot.FEET).copy());
                    this.setItemSlot(EquipmentSlot.FEET, stack.copy());
                    this.setGuaranteedDrop(EquipmentSlot.FEET);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (stack.has(DataComponents.FOOD)) {
                if (!this.level().isClientSide) {
                    player.setItemInHand(hand, this.getOffhandItem().copy());
                    this.setItemSlot(EquipmentSlot.OFFHAND, stack.copy());
                    this.setGuaranteedDrop(EquipmentSlot.OFFHAND);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!stack.isEmpty()) {
                if (!this.level().isClientSide) {
                    player.setItemInHand(hand, this.getMainHandItem().copy());
                    this.setItemSlot(EquipmentSlot.MAINHAND, stack.copy());
                    this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (this.getItemBySlot(slot).isEmpty()) continue;
                if (!this.level().isClientSide) {
                    player.setItemInHand(hand, this.getItemBySlot(slot).copy());
                    this.setItemSlot(slot, ItemStack.EMPTY);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        return super.mobInteract(player, hand);
    }

    public boolean canBreed() {
        return !this.makingLove && this.breedCooldown <= 0 && !this.isHired() && !this.isBaby() && this.level().getRawBrightness(this.blockPosition(), 0) < 12 && this.level().getEntitiesOfClass(Stranghoul.class, this.getBoundingBox().inflate(10.0)).stream().filter(Stranghoul::isBaby).count() < 5L;
    }

    public final boolean unableToMoveToHirer() {
        return this.isPassenger() || this.mayBeLeashed() || this.getOwner() != null && this.getOwner().isSpectator();
    }

    public void tryToTeleportToHirer() {
        LivingEntity livingEntity = this.getHirer();
        if (livingEntity != null) {
            this.teleportToAroundBlockPos(livingEntity.blockPosition());
        }
    }

    private void teleportToAroundBlockPos(BlockPos blockPos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.random.nextIntBetweenInclusive(-3, 3);
            int k = this.random.nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(blockPos.getX() + j, blockPos.getY() + l, blockPos.getZ() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int i, int j, int k) {
        if (!this.canTeleportTo(new BlockPos(i, j, k))) {
            return false;
        }
        this.moveTo((float)i + 0.5f, j, (float)k + 0.5f, this.getYRot(), this.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos blockPos) {
        PathType pathType = WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)blockPos);
        if (pathType != PathType.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level().getBlockState(blockPos.below());
        if (blockState.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos2 = blockPos.subtract((Vec3i)this.blockPosition());
        return this.level().noCollision((Entity)this, this.getBoundingBox().move(blockPos2));
    }

    public void addHappyParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                double d = this.getRandom().nextGaussian() * 0.02;
                double e = this.getRandom().nextGaussian() * 0.02;
                double f = this.getRandom().nextGaussian() * 0.02;
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 1.0, this.getRandomZ(1.0), d, e, f));
            }
        }
    }

    public void addAlliedParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                double d = this.getRandom().nextGaussian() * 0.02;
                double e = this.getRandom().nextGaussian() * 0.02;
                double f = this.getRandom().nextGaussian() * 0.02;
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((ParticleOptions)ESParticles.ALLIED.get(), this.getRandomX(1.0), this.getRandomY() + 1.0, this.getRandomZ(1.0), d, e, f));
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity living;
        Entity entity = source.getDirectEntity();
        return super.hurt(source, (float)(entity instanceof LivingEntity && (living = (LivingEntity)entity).getWeaponItem().is(ESTags.Items.STRANGHOUL_VULNERABLE_TO) ? 2 : 1) * amount);
    }

    public boolean canBeAffected(MobEffectInstance instance) {
        return !instance.is(MobEffects.HUNGER) && !instance.is(ESMobEffects.TEARY.asHolder()) && super.canBeAffected(instance);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (BABY.equals(accessor)) {
            this.refreshDimensions();
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.addPersistentAngerSaveData(compoundTag);
        compoundTag.put(TAG_HOME_POS, (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.homePos).getOrThrow());
        compoundTag.putBoolean(TAG_BABY, this.isBaby());
        compoundTag.putInt(TAG_GROWTH_TICKS, this.growthTicks);
        compoundTag.putInt(TAG_BREED_COOLDOWN, this.breedCooldown);
        compoundTag.putInt(TAG_ADMIRATION_TICKS, this.admirationTicks);
        if (this.hirer != null) {
            compoundTag.putUUID(TAG_HIRER, this.hirer.getUUID());
        }
        compoundTag.putInt(TAG_HIRED_TICKS_LEFT, this.hiredTicksLeft);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.readPersistentAngerSaveData(this.level(), compoundTag);
        if (compoundTag.contains(TAG_HOME_POS)) {
            GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(TAG_HOME_POS)).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Failed to parse Stranghoul home pos: {}", s)).ifPresent(pos -> {
                this.homePos = pos;
            });
        }
        if (compoundTag.contains(TAG_BABY, 1)) {
            this.setBaby(compoundTag.getBoolean(TAG_BABY));
        }
        this.growthTicks = compoundTag.getInt(TAG_GROWTH_TICKS);
        this.breedCooldown = compoundTag.getInt(TAG_BREED_COOLDOWN);
        this.admirationTicks = compoundTag.getInt(TAG_ADMIRATION_TICKS);
        if (compoundTag.hasUUID(TAG_HIRER)) {
            this.hirerId = compoundTag.getUUID(TAG_HIRER);
        }
        this.hiredTicksLeft = compoundTag.getInt(TAG_HIRED_TICKS_LEFT);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ESSoundEvents.STRANGHOUL_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ESSoundEvents.STRANGHOUL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ESSoundEvents.STRANGHOUL_DEATH.get();
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int i) {
        this.remainingPersistentAngerTime = i;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.getRandom()));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.hirerId;
    }

    public static boolean checkStranghoulSpawnRules(EntityType<? extends Stranghoul> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Stranghoul.checkAnyLightMonsterSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && ESConfig.INSTANCE.mobsConfig.stranghoul.canSpawn();
    }

    private class EatGoal
    extends Goal {
        private int eatTicks = 0;

        private EatGoal() {
        }

        public void start() {
            this.eatTicks = 0;
            if (!Stranghoul.this.getOffhandItem().has(DataComponents.FOOD)) {
                BuiltInRegistries.ITEM.getRandomElementOf(ESTags.Items.STRANGHOUL_FOOD, Stranghoul.this.random).ifPresent(item -> {
                    Stranghoul.this.spawnAtLocation(Stranghoul.this.getOffhandItem());
                    Stranghoul.this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack(item));
                });
            }
            if (Stranghoul.this.getOffhandItem().has(DataComponents.FOOD)) {
                Stranghoul.this.setEating(true);
            }
        }

        public void tick() {
            Level level;
            ++this.eatTicks;
            ItemStack food = Stranghoul.this.getOffhandItem();
            if (this.eatTicks == 32) {
                FoodProperties foodProperties = (FoodProperties)food.get(DataComponents.FOOD);
                if (foodProperties != null) {
                    Stranghoul.this.heal((float)foodProperties.nutrition() + foodProperties.saturation() * 3.0f);
                }
                Stranghoul.this.eat(Stranghoul.this.level(), food);
            }
            if (this.eatTicks % 4 == 0 && (level = Stranghoul.this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!food.isEmpty()) {
                    for (int i = 0; i < (this.eatTicks == 32 ? 16 : 5); ++i) {
                        Vec3 vec3 = new Vec3((double)(Stranghoul.this.random.nextFloat() - 0.5f) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                        vec3 = vec3.xRot((float)((double)(-Stranghoul.this.getXRot()) * (Math.PI / 180)));
                        vec3 = vec3.yRot((float)((double)(-Stranghoul.this.getYHeadRot()) * (Math.PI / 180)));
                        double d0 = (double)(-Stranghoul.this.random.nextFloat()) * 0.6 - 0.3;
                        Vec3 vec31 = new Vec3((double)(Stranghoul.this.random.nextFloat() - 0.5f) * 0.3, d0, 0.6);
                        vec31 = vec31.xRot((float)((double)(-Stranghoul.this.getXRot()) * (Math.PI / 180)));
                        vec31 = vec31.yRot((float)((double)(-Stranghoul.this.getYHeadRot()) * (Math.PI / 180)));
                        vec31 = vec31.add(Stranghoul.this.getX(), Stranghoul.this.getEyeY(), Stranghoul.this.getZ());
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, food), vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z));
                    }
                }
                Stranghoul.this.playSound(Stranghoul.this.getEatingSound(food), 0.5f + 0.5f * (float)Stranghoul.this.random.nextInt(2), (Stranghoul.this.random.nextFloat() - Stranghoul.this.random.nextFloat()) * 0.2f + 1.0f);
            }
        }

        public void stop() {
            Stranghoul.this.setEating(false);
            if (Stranghoul.this.hiredEatAnim) {
                Stranghoul.this.hiredEatAnim = false;
                Stranghoul.this.addAlliedParticles();
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean canUse() {
            if (Stranghoul.this.hiredEatAnim) {
                return true;
            }
            return Stranghoul.this.random.nextInt(EatGoal.reducedTickDelay((int)80)) == 0 && (Stranghoul.this.getHealth() / Stranghoul.this.getMaxHealth() < 0.4f || Stranghoul.this.getOffhandItem().has(DataComponents.FOOD) && Stranghoul.this.getHealth() < Stranghoul.this.getMaxHealth());
        }

        public boolean canContinueToUse() {
            return Stranghoul.this.getOffhandItem().has(DataComponents.FOOD) && this.eatTicks <= 32;
        }
    }

    private class SeedsLauncherAttackGoal
    extends RangedAttackGoal {
        public SeedsLauncherAttackGoal() {
            super((RangedAttackMob)Stranghoul.this, 1.0, 30, 5.0f);
        }

        public boolean canUse() {
            return super.canUse() && Stranghoul.this.getMainHandItem().getItem() instanceof SeedsLauncherItem;
        }

        public void start() {
            super.start();
            Stranghoul.this.setAggressive(true);
        }

        public void stop() {
            super.stop();
            Stranghoul.this.setAggressive(false);
        }
    }

    private class SpearAttackGoal
    extends RangedAttackGoal {
        public SpearAttackGoal() {
            super((RangedAttackMob)Stranghoul.this, 1.0, 40, 10.0f);
        }

        public boolean canUse() {
            return super.canUse() && Stranghoul.this.getMainHandItem().getItem() instanceof SpearItem;
        }

        public void start() {
            super.start();
            Stranghoul.this.setAggressive(true);
            Stranghoul.this.startUsingItem(InteractionHand.MAIN_HAND);
        }

        public void stop() {
            super.stop();
            Stranghoul.this.stopUsingItem();
            Stranghoul.this.setAggressive(false);
        }
    }

    private class FollowHirerGoal
    extends Goal {
        @Nullable
        private LivingEntity hirer;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private float oldWaterCost;

        public FollowHirerGoal() {
            this.navigation = Stranghoul.this.getNavigation();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingEntity = Stranghoul.this.getHirer();
            if (livingEntity == null) {
                return false;
            }
            if (Stranghoul.this.unableToMoveToHirer()) {
                return false;
            }
            if (Stranghoul.this.distanceToSqr((Entity)livingEntity) < 100.0) {
                return false;
            }
            this.hirer = livingEntity;
            return true;
        }

        public boolean canContinueToUse() {
            if (this.navigation.isDone()) {
                return false;
            }
            if (this.hirer == null) {
                return false;
            }
            if (Stranghoul.this.unableToMoveToHirer()) {
                return false;
            }
            return !(Stranghoul.this.distanceToSqr((Entity)this.hirer) <= 4.0);
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = Stranghoul.this.getPathfindingMalus(PathType.WATER);
            Stranghoul.this.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.hirer = null;
            this.navigation.stop();
            Stranghoul.this.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            boolean shouldTeleport;
            boolean bl = shouldTeleport = this.hirer != null && Stranghoul.this.distanceToSqr((Entity)this.hirer) >= 144.0;
            if (!shouldTeleport && this.hirer != null) {
                Stranghoul.this.getLookControl().setLookAt((Entity)this.hirer, 10.0f, (float)Stranghoul.this.getMaxHeadXRot());
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                if (shouldTeleport) {
                    Stranghoul.this.tryToTeleportToHirer();
                } else if (this.hirer != null) {
                    this.navigation.moveTo((Entity)this.hirer, 1.0);
                }
            }
        }
    }

    private class BreedGoal
    extends Goal {
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
        protected final Stranghoul stranghoul;
        protected final Level level;
        @Nullable
        protected Stranghoul partner;
        private int loveTime;

        public BreedGoal(Stranghoul stranghoul) {
            this.stranghoul = stranghoul;
            this.level = stranghoul.level();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.stranghoul.getRandom().nextInt(BreedGoal.reducedTickDelay((int)80)) != 0 || !this.stranghoul.canBreed()) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partner != null;
        }

        public boolean canContinueToUse() {
            return this.partner != null && this.partner.isAlive() && this.loveTime < 60;
        }

        public void start() {
            this.stranghoul.makingLove = true;
            if (this.partner != null) {
                this.partner.makingLove = true;
            }
        }

        public void stop() {
            this.stranghoul.makingLove = false;
            if (this.partner != null) {
                this.partner.makingLove = false;
            }
            this.partner = null;
            this.loveTime = 0;
        }

        public void tick() {
            if (this.partner != null) {
                this.stranghoul.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.stranghoul.getMaxHeadXRot());
                this.stranghoul.getNavigation().moveTo((Entity)this.partner, 1.0);
                ++this.loveTime;
                if (this.loveTime >= this.adjustedTickDelay(60) && this.stranghoul.distanceToSqr((Entity)this.partner) < 9.0) {
                    Stranghoul baby = new Stranghoul(ESEntities.STRANGHOUL.get(), this.level);
                    baby.setBaby(true);
                    baby.moveTo(this.stranghoul.getX(), this.stranghoul.getY(), this.stranghoul.getZ(), 0.0f, 0.0f);
                    Level level = this.level;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        baby.finalizeSpawn((ServerLevelAccessor)serverLevel, this.level.getCurrentDifficultyAt(baby.blockPosition()), MobSpawnType.BREEDING, null);
                    }
                    this.level.addFreshEntity((Entity)baby);
                    baby.addHappyParticles();
                    this.stranghoul.breedCooldown = 24000;
                    this.partner.breedCooldown = 24000;
                    this.loveTime = 60;
                }
            }
        }

        @Nullable
        private Stranghoul getFreePartner() {
            List<Stranghoul> list = this.level.getNearbyEntities(Stranghoul.class, PARTNER_TARGETING, (LivingEntity)this.stranghoul, this.stranghoul.getBoundingBox().inflate(8.0)).stream().filter(Stranghoul::canBreed).sorted(Comparator.comparingDouble(s -> s.distanceTo((Entity)this.stranghoul))).toList();
            return list.isEmpty() ? null : list.getFirst();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    private class GoToWantedItemGoal
    extends Goal {
        private ItemEntity wantedItem;

        public GoToWantedItemGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            List<ItemEntity> items;
            if (Stranghoul.this.isBaby()) {
                return false;
            }
            if (Stranghoul.this.getRandom().nextInt(GoToWantedItemGoal.reducedTickDelay((int)80)) == 0 && !Stranghoul.this.getOffhandItem().is(ESTags.Items.STRANGHOUL_CURRENCIES) && !(items = Stranghoul.this.level().getEntitiesOfClass(ItemEntity.class, Stranghoul.this.getBoundingBox().inflate(15.0)).stream().filter(i -> i.getItem().is(ESTags.Items.STRANGHOUL_CURRENCIES) && Stranghoul.this.hasLineOfSight((Entity)i)).sorted(Comparator.comparingDouble(i -> i.distanceTo((Entity)Stranghoul.this))).toList()).isEmpty()) {
                this.wantedItem = items.getFirst();
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.wantedItem != null && this.wantedItem.isAlive();
        }

        public void stop() {
            this.wantedItem = null;
        }

        public void tick() {
            if (this.wantedItem != null) {
                Stranghoul.this.getLookControl().setLookAt((Entity)this.wantedItem, 10.0f, (float)Stranghoul.this.getMaxHeadXRot());
                Stranghoul.this.getNavigation().moveTo((Entity)this.wantedItem, 1.0);
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    private class GoHomeGoal
    extends Goal {
        private int tryTicks = 0;

        public GoHomeGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return Stranghoul.this.getRandom().nextInt(GoHomeGoal.reducedTickDelay((int)120)) == 0 && Stranghoul.this.homePos.dimension() == Stranghoul.this.level().dimension() && !Stranghoul.this.blockPosition().closerThan((Vec3i)Stranghoul.this.homePos.pos(), 20.0);
        }

        public boolean canContinueToUse() {
            return Stranghoul.this.homePos.dimension() == Stranghoul.this.level().dimension() && !Stranghoul.this.blockPosition().closerThan((Vec3i)Stranghoul.this.homePos.pos(), 10.0) && this.tryTicks < 600;
        }

        public void stop() {
            this.tryTicks = 0;
        }

        public void tick() {
            ++this.tryTicks;
            Stranghoul.this.getNavigation().moveTo((double)Stranghoul.this.homePos.pos().getX() + 0.5, (double)Stranghoul.this.homePos.pos().getY() + 0.5, (double)Stranghoul.this.homePos.pos().getZ() + 0.5, 1.0);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    private class PlantCropGoal
    extends MoveToBlockGoal {
        public PlantCropGoal() {
            super((PathfinderMob)Stranghoul.this, 1.0, 20, 15);
        }

        public boolean canUse() {
            if (Stranghoul.this.isHired() || !ESPlatform.INSTANCE.canEntityGrief(Stranghoul.this.level(), (Entity)Stranghoul.this)) {
                return false;
            }
            return Stranghoul.this.getMainHandItem().is(ItemTags.HOES) && !Stranghoul.this.isBartering() && super.canUse();
        }

        public void tick() {
            BlockPos cropPos;
            Level level;
            BlockState blockState;
            super.tick();
            if (this.isReachedTarget() && (blockState = (level = Stranghoul.this.level()).getBlockState(cropPos = this.blockPos.above())).isAir()) {
                level.setBlockAndUpdate(cropPos, ESBlocks.PUNGENCY_FRUIT_VINES.get().defaultBlockState());
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, cropPos, GameEvent.Context.of((Entity)Stranghoul.this));
                Stranghoul.this.swing(InteractionHand.MAIN_HAND);
                Stranghoul.this.addHappyParticles();
            }
        }

        public double acceptedDistance() {
            return 2.5;
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            return ESBlocks.PUNGENCY_FRUIT_VINES.get().canPlaceSeeds(state, (BlockGetter)level, pos) && level.getBlockState(pos.above()).isAir();
        }
    }

    private class CropGoal
    extends MoveToBlockGoal {
        public CropGoal() {
            super((PathfinderMob)Stranghoul.this, 1.0, 20, 15);
        }

        public boolean canUse() {
            if (Stranghoul.this.isHired() || !ESPlatform.INSTANCE.canEntityGrief(Stranghoul.this.level(), (Entity)Stranghoul.this)) {
                return false;
            }
            return Stranghoul.this.getMainHandItem().is(ItemTags.HOES) && !Stranghoul.this.isBartering() && super.canUse();
        }

        public void tick() {
            Level level;
            BlockState blockState;
            super.tick();
            if (this.isReachedTarget() && (blockState = (level = Stranghoul.this.level()).getBlockState(this.blockPos)).is((Block)ESBlocks.PUNGENCY_FRUIT_VINES.get()) && (Integer)blockState.getValue((Property)PungencyFruitVinesBlock.AGE) == 7 && ESPlatform.INSTANCE.postEntityDestroyBlockEvent(level, this.blockPos, (Entity)Stranghoul.this)) {
                level.destroyBlock(this.blockPos, true, (Entity)Stranghoul.this);
                Stranghoul.this.swing(InteractionHand.MAIN_HAND);
                Stranghoul.this.addHappyParticles();
            }
        }

        public double acceptedDistance() {
            return 2.5;
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            return state.is((Block)ESBlocks.PUNGENCY_FRUIT_VINES.get()) && (Integer)state.getValue((Property)PungencyFruitVinesBlock.AGE) == 7;
        }
    }

    private class DryRottenFleshGoal
    extends MoveToBlockGoal {
        public DryRottenFleshGoal() {
            super((PathfinderMob)Stranghoul.this, 1.0, 20, 15);
        }

        public boolean canUse() {
            if (Stranghoul.this.isHired() || !ESPlatform.INSTANCE.canEntityGrief(Stranghoul.this.level(), (Entity)Stranghoul.this)) {
                return false;
            }
            return Stranghoul.this.getOffhandItem().is(Items.ROTTEN_FLESH) && !Stranghoul.this.isBartering() && super.canUse();
        }

        public boolean canContinueToUse() {
            return Stranghoul.this.getOffhandItem().is(Items.ROTTEN_FLESH) && super.canContinueToUse();
        }

        public void tick() {
            Level level;
            super.tick();
            if (this.isReachedTarget() && this.isValidTarget((LevelReader)(level = Stranghoul.this.level()), this.blockPos)) {
                BlockEntity blockEntity = level.getBlockEntity(this.blockPos);
                if (blockEntity instanceof DryingRackBlockEntity) {
                    DryingRackBlockEntity entity = (DryingRackBlockEntity)blockEntity;
                    entity.setItem(Stranghoul.this.getOffhandItem().copyWithCount(1));
                    Stranghoul.this.getOffhandItem().consume(1, (LivingEntity)Stranghoul.this);
                }
                Stranghoul.this.swing(InteractionHand.OFF_HAND);
                Stranghoul.this.addHappyParticles();
            }
        }

        public double acceptedDistance() {
            return 2.5;
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            DryingRackBlockEntity entity;
            BlockEntity blockEntity;
            return level.getBlockState(pos).is((Block)ESBlocks.DRYING_RACK.get()) && (blockEntity = level.getBlockEntity(pos)) instanceof DryingRackBlockEntity && ((entity = (DryingRackBlockEntity)blockEntity).getItem().isEmpty() || entity.getItem().is(ESItems.ROTTEN_FLESH_JERKY.get()) || entity.getItem().is(Items.LEATHER));
        }
    }

    private class HirerHurtByTargetGoal
    extends TargetGoal {
        private LivingEntity hirerLastHurtBy;
        private int timestamp;

        public HirerHurtByTargetGoal() {
            super((Mob)Stranghoul.this, false);
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            if (Stranghoul.this.isHired()) {
                LivingEntity living = Stranghoul.this.getHirer();
                if (living == null) {
                    return false;
                }
                this.hirerLastHurtBy = living.getLastHurtByMob();
                int i = living.getLastHurtByMobTimestamp();
                return i != this.timestamp && this.canAttack(this.hirerLastHurtBy, TargetingConditions.DEFAULT);
            }
            return false;
        }

        public void start() {
            this.mob.setTarget(this.hirerLastHurtBy);
            LivingEntity living = Stranghoul.this.getHirer();
            if (living != null) {
                this.timestamp = living.getLastHurtByMobTimestamp();
            }
            super.start();
        }
    }

    private class HirerHurtTargetGoal
    extends TargetGoal {
        private LivingEntity hirerLastHurt;
        private int timestamp;

        public HirerHurtTargetGoal() {
            super((Mob)Stranghoul.this, false);
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            if (Stranghoul.this.isHired()) {
                LivingEntity livingEntity = Stranghoul.this.getHirer();
                if (livingEntity == null) {
                    return false;
                }
                this.hirerLastHurt = livingEntity.getLastHurtMob();
                int i = livingEntity.getLastHurtMobTimestamp();
                return i != this.timestamp && this.canAttack(this.hirerLastHurt, TargetingConditions.DEFAULT);
            }
            return false;
        }

        public void start() {
            this.mob.setTarget(this.hirerLastHurt);
            LivingEntity livingEntity = Stranghoul.this.getHirer();
            if (livingEntity != null) {
                this.timestamp = livingEntity.getLastHurtMobTimestamp();
            }
            super.start();
        }
    }
}

