/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.Permafrost;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.projectile.FrozenTube;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PermafrostRangedPhase
extends BehaviorPhase<Permafrost> {
    public static final int ID = 4;

    public PermafrostRangedPhase() {
        super(4, 1, 65, 100);
    }

    @Override
    public boolean canStart(Permafrost entity, boolean cooldownOver) {
        return cooldownOver && this.canReachTarget(entity, 20.0);
    }

    @Override
    public void onStart(Permafrost entity) {
    }

    @Override
    public void tick(Permafrost entity) {
        Level level = entity.level();
        if (entity.getTarget() != null) {
            LivingEntity target = entity.getTarget();
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
            Vec3 launchPos = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            if (entity.getBehaviorTicks() >= 21 && entity.getBehaviorTicks() <= 45) {
                for (LivingEntity livingEntity : entity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)entity, entity.getBoundingBox().inflate(1.5))) {
                    Targeting targeting;
                    if (livingEntity != target && (!(livingEntity instanceof Targeting) || (targeting = (Targeting)livingEntity).getTarget() != entity)) continue;
                    entity.doHurtTarget((Entity)livingEntity);
                    livingEntity.hurtMarked = true;
                    livingEntity.addDeltaMovement(livingEntity.position().subtract(entity.position()).normalize().scale(2.0));
                }
                if (entity.getBehaviorTicks() % 3 == 0) {
                    for (int i = 0; i <= 5; ++i) {
                        Vec3 targetPos = i == 0 ? target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0) : ESMathUtil.rotationToPosition(launchPos, 1.0f, 15.0f, 360.0f * (float)i / 5.0f + (float)entity.getRandom().nextInt(72));
                        Vec3 delta = targetPos.subtract(launchPos).normalize();
                        FrozenTube tube = new FrozenTube(level, (LivingEntity)entity);
                        tube.shoot(delta.x, delta.y, delta.z, i == 0 ? 1.25f : 0.5f, i == 0 ? 0.1f : 0.3f);
                        tube.setPos(launchPos);
                        tube.playSound(ESSoundEvents.FROZEN_TUBE_THROW.get());
                        level.addFreshEntity((Entity)tube);
                    }
                }
            }
        }
    }

    @Override
    public boolean canContinue(Permafrost entity) {
        return true;
    }

    @Override
    public void onStop(Permafrost entity) {
    }
}

