/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack.ray;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class RayAttack
extends Entity
implements TraceableEntity {
    protected static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.defineId(RayAttack.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> PITCH = SynchedEntityData.defineId(RayAttack.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(RayAttack.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.defineId(RayAttack.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public float renderPitch;
    public float renderYaw;
    public float prevPitch;
    public float prevYaw;
    private final Object2IntArrayMap<BlockPos> destroyProgresses = new Object2IntArrayMap();

    public Optional<Entity> getCaster() {
        return Optional.ofNullable(this.level().getEntity(((Integer)this.getEntityData().get(CASTER)).intValue()));
    }

    public void setCaster(Entity caster) {
        this.getEntityData().set(CASTER, (Object)caster.getId());
    }

    public float getPitch() {
        return ((Float)this.getEntityData().get(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.getEntityData().set(PITCH, (Object)Float.valueOf(pitch));
    }

    public float getYaw() {
        return ((Float)this.getEntityData().get(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.getEntityData().set(YAW, (Object)Float.valueOf(yaw));
    }

    public float getLength() {
        return ((Float)this.getEntityData().get(LENGTH)).floatValue();
    }

    public void setLength(float length) {
        this.getEntityData().set(LENGTH, (Object)Float.valueOf(length));
    }

    public RayAttack(EntityType<? extends RayAttack> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public RayAttack(EntityType<? extends RayAttack> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch) {
        this(type, world);
        this.setCaster((Entity)caster);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setLength(this.getRadius());
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CASTER, (Object)-1).define(PITCH, (Object)Float.valueOf(0.0f)).define(YAW, (Object)Float.valueOf(0.0f)).define(LENGTH, (Object)Float.valueOf(0.0f));
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            boolean hasBlock;
            Vec3 idealEndPos;
            this.update();
            Vec3 endPos = idealEndPos = ESMathUtil.rotationToPosition(this.position(), this.getRadius(), this.getPitch(), this.getYaw());
            ESEntityUtil.RaytraceResult result = ESEntityUtil.raytrace((LevelAccessor)this.level(), CollisionContext.of((Entity)this), this.position(), idealEndPos);
            this.onFirstHit(result);
            boolean bl = hasBlock = result.blockHitResult() != null && result.blockHitResult().getType() != HitResult.Type.MISS;
            if (hasBlock) {
                endPos = result.blockHitResult().getLocation();
            }
            this.setLength((float)endPos.distanceTo(this.position()));
            result = ESEntityUtil.raytrace((LevelAccessor)this.level(), CollisionContext.of((Entity)this), this.position(), endPos);
            this.onHit(result);
        } else {
            this.prevYaw = this.renderYaw;
            this.prevPitch = this.renderPitch;
            this.renderYaw = this.getYaw();
            this.renderPitch = this.getPitch();
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
            Vec3 endPos = ESMathUtil.rotationToPosition(this.position(), this.getLength(), this.getPitch(), this.getYaw());
            this.addEndParticles(endPos);
        }
    }

    public int getRadius() {
        return 20;
    }

    public void onFirstHit(ESEntityUtil.RaytraceResult result) {
        this.getCaster().ifPresent(caster -> {
            if (result.blockHitResult() != null) {
                BlockPos hitPos;
                this.destroyProgresses.put((Object)hitPos, this.destroyProgresses.containsKey((Object)(hitPos = result.blockHitResult().getBlockPos())) ? this.destroyProgresses.getInt((Object)hitPos) + 1 : 1);
                if (this.destroyProgresses.getInt((Object)hitPos) > 60) {
                    BlockState blockState;
                    boolean canDestroy;
                    boolean bl = canDestroy = ESPlatform.INSTANCE.postEntityDestroyBlockEvent(this.level(), hitPos, (Entity)caster) && ESConfig.INSTANCE.laserBeamBreakBlocks;
                    if (canDestroy && (blockState = this.level().getBlockState(hitPos)).getDestroySpeed((BlockGetter)this.level(), hitPos) >= 0.0f) {
                        this.level().destroyBlock(hitPos, true, (Entity)this);
                    }
                }
            }
        });
        while (this.destroyProgresses.size() > 32) {
            this.destroyProgresses.removeInt(this.destroyProgresses.keySet().stream().sorted().toList().getFirst());
        }
    }

    public void onHit(ESEntityUtil.RaytraceResult result) {
        for (Entity target : result.entities()) {
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)target;
            if (!this.getCaster().isEmpty() && living == this.getCaster().get()) continue;
            this.doHurtTarget(living);
        }
    }

    public void doHurtTarget(LivingEntity target) {
        this.getCaster().ifPresent(caster -> {
            if (ESEntityUtil.shouldHarm(caster, (Entity)target) && target.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.LASER, this, caster), this.getAttackDamage())) {
                target.setRemainingFireTicks(Math.max(target.getRemainingFireTicks(), 100));
            }
        });
    }

    public void addEndParticles(Vec3 endPos) {
    }

    public float getRotationSpeed() {
        return 1.0f;
    }

    public float getAttackDamage() {
        return 8.0f;
    }

    public void push(Entity entity) {
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 1024.0;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    private void update() {
        this.updateRotations();
        this.updatePosition();
    }

    protected float rotateTowards(float from, float to, float maxAngle) {
        float f = Mth.degreesDifference((float)from, (float)to);
        float f1 = Mth.clamp((float)f, (float)(-maxAngle), (float)maxAngle);
        return from + f1;
    }

    public void updateRotations() {
        this.getCaster().ifPresent(caster -> {
            if (caster instanceof LivingEntity) {
                RayAttackUser shooter;
                LivingEntity living = (LivingEntity)caster;
                if (caster instanceof RayAttackUser && !(shooter = (RayAttackUser)caster).isRayFollowingHeadRotation()) {
                    Vec3 idealEndPos = ESMathUtil.rotationToPosition(this.position(), this.getRadius(), this.getPitch(), this.getYaw());
                    shooter.updateRayEnd(idealEndPos);
                    Vec3 wantedPos = shooter.getRayRotationTarget();
                    float wantedYaw = ESMathUtil.positionToYaw(this.position(), wantedPos);
                    float wantedPitch = ESMathUtil.positionToPitch(this.position(), wantedPos);
                    float currentYaw = this.getYaw();
                    float currentPitch = this.getPitch();
                    this.setYaw(this.rotateTowards(currentYaw, wantedYaw, this.getRotationSpeed()));
                    this.setPitch(this.rotateTowards(currentPitch, wantedPitch, this.getRotationSpeed()));
                } else {
                    this.setYaw(living.yHeadRot + 90.0f);
                    this.setPitch(-caster.getXRot());
                }
            }
        });
    }

    public void updatePosition() {
        this.getCaster().ifPresent(caster -> this.setPos(this.getPositionForCaster((Entity)caster, caster.position())));
    }

    public Vec3 getPositionForCaster(Entity caster, Vec3 casterPos) {
        return casterPos;
    }

    @Nullable
    public Entity getOwner() {
        return this.getCaster().orElse(null);
    }
}

