/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class EnergizedFlame
extends Entity
implements TraceableEntity {
    private static final String TAG_OWNER = "owner";
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerId;

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.ownerId = owner.getUUID();
        this.owner = owner;
    }

    public EnergizedFlame(EntityType<? extends EnergizedFlame> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 100) {
            this.discard();
        }
        if (!this.level().isClientSide) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.owner == null && this.ownerId != null) {
                    Entity entity = serverLevel.getEntity(this.ownerId);
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity;
                        this.owner = livingEntity = (LivingEntity)entity;
                    }
                    if (this.owner == null) {
                        this.ownerId = null;
                    }
                }
            }
            if (this.tickCount == 20) {
                this.playSound(SoundEvents.FIRECHARGE_USE, 1.0f, (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
            if (this.tickCount > 20 && this.getOwner() != null) {
                AABB box = this.getBoundingBox().inflate(0.5, 1.0, 0.5);
                for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, box)) {
                    if (!ESEntityUtil.shouldHarm((Entity)this.getOwner(), (Entity)livingEntity)) continue;
                    livingEntity.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.ENERGIZED_FLAME, this, (Entity)this.getOwner()), 2.0f);
                    livingEntity.setRemainingFireTicks(Math.max(livingEntity.getRemainingFireTicks(), 60));
                }
            }
        } else {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + (this.random.nextDouble() - 0.5) * 1.0, this.getY() + 0.25 + (this.random.nextDouble() - 0.5) * 1.0, this.getZ() + (this.random.nextDouble() - 0.5) * 1.0, 0.0, 1.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + (this.random.nextDouble() - 0.5) * 1.0, this.getY() + 0.25 + (this.random.nextDouble() - 0.5) * 1.0, this.getZ() + (this.random.nextDouble() - 0.5) * 1.0, 0.0, 0.2, 0.0);
        }
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.discard();
        }
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        if (compoundTag.hasUUID(TAG_OWNER)) {
            this.ownerId = compoundTag.getUUID(TAG_OWNER);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        if (this.owner != null) {
            compoundTag.putUUID(TAG_OWNER, this.owner.getUUID());
        }
    }
}

