/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.LuminoFishModel;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.LuminoFishGlowLayer;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Luminofish;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LuminoFishRenderer<T extends Luminofish>
extends MobRenderer<T, LuminoFishModel<T>> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/luminofish.png");

    public LuminoFishRenderer(EntityRendererProvider.Context context) {
        super(context, new LuminoFishModel(context.bakeLayer(LuminoFishModel.LAYER_LOCATION)), 0.3f);
        this.addLayer((RenderLayer)new LuminoFishGlowLayer(this));
    }

    protected void setupRotations(T livingEntity, PoseStack poseStack, float f, float g, float h, float i) {
        super.setupRotations(livingEntity, poseStack, f, g, h, i);
        if (!livingEntity.isInWater()) {
            poseStack.translate(0.1f, 0.1f, -0.1f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ENTITY_TEXTURE;
    }
}

