/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.blockentity;

import cn.leolezury.eternalstarlight.common.block.StarfireBirdNestBlock;
import cn.leolezury.eternalstarlight.common.block.entity.StarfireBirdNestBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarfireBirdNestRenderer
implements BlockEntityRenderer<StarfireBirdNestBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;
    private final ItemRenderer itemRenderer;

    public StarfireBirdNestRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(StarfireBirdNestBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float f;
        List<StarfireBirdNestBlockEntity.BirdData> adults = blockEntity.getAdults();
        int adultCount = adults.size();
        float slightOffset = 0.001f;
        float singleOffset = adultCount == 1 ? 0.0f : 0.4f / (float)(adultCount - 1);
        float offset = adultCount == 1 ? 0.0f : -0.2f;
        for (StarfireBirdNestBlockEntity.BirdData adult : adults) {
            Object entity;
            if (blockEntity.getLevel() != null && (entity = adult.getOrCreateEntityInstance(blockEntity.getLevel(), blockEntity.getBlockPos())) != null) {
                poseStack.pushPose();
                poseStack.translate(0.5f + slightOffset, 0.025f + slightOffset, 0.5f + slightOffset);
                poseStack.mulPose(Axis.YP.rotationDegrees(-((Direction)blockEntity.getBlockState().getValue((Property)StarfireBirdNestBlock.FACING)).toYRot()));
                poseStack.translate(offset, 0.0f, 0.0f);
                this.entityRenderer.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, bufferSource, packedLight);
                poseStack.popPose();
            }
            slightOffset += 0.001f;
            offset += singleOffset;
        }
        List<StarfireBirdNestBlockEntity.BirdData> babies = blockEntity.getBabies();
        int babyCount = blockEntity.getBabies().size();
        slightOffset = 0.001f;
        singleOffset = babyCount == 1 ? 0.0f : 0.4f / (float)(babyCount - 1);
        offset = babyCount == 1 ? 0.0f : -0.2f;
        for (StarfireBirdNestBlockEntity.BirdData baby : babies) {
            Entity entity;
            if (blockEntity.getLevel() != null && (entity = baby.getOrCreateEntityInstance(blockEntity.getLevel(), blockEntity.getBlockPos())) != null) {
                poseStack.pushPose();
                poseStack.translate(0.5f + slightOffset, 0.125f + slightOffset, 0.5f + slightOffset);
                poseStack.mulPose(Axis.YP.rotationDegrees(-((Direction)blockEntity.getBlockState().getValue((Property)StarfireBirdNestBlock.FACING)).toYRot()));
                poseStack.translate(offset, 0.0f, -0.125f);
                this.entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, bufferSource, packedLight);
                poseStack.popPose();
            }
            slightOffset += 0.001f;
            offset += singleOffset;
        }
        long seed = blockEntity.getBlockPos().asLong();
        List<ItemStack> seeds = blockEntity.getItems().stream().filter(stack -> !stack.isEmpty()).toList();
        slightOffset = 0.001f;
        Block block = blockEntity.getBlockState().getBlock();
        if (block instanceof StarfireBirdNestBlock) {
            StarfireBirdNestBlock block2 = (StarfireBirdNestBlock)block;
            f = block2.getSeedsRenderOffset();
        } else {
            f = 0.0f;
        }
        float seedsOffset = f;
        for (int i = 0; i < seeds.size(); ++i) {
            ItemStack stack2 = seeds.get(i);
            if (!stack2.isEmpty()) {
                poseStack.pushPose();
                poseStack.translate(0.5f + slightOffset, seedsOffset + slightOffset, 0.5f + slightOffset);
                poseStack.mulPose(Axis.YP.rotationDegrees((float)i * 30.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.scale(0.375f, 0.375f, 0.375f);
                this.itemRenderer.renderStatic(stack2, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), (int)((long)i + seed));
                poseStack.popPose();
            }
            slightOffset += 0.001f;
            seedsOffset += 0.0234375f;
        }
    }
}

