/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Rookfish;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RookfishModel<T extends Rookfish>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("rookfish"), "main");
    private final ModelPart root;
    private final ModelPart[] legs = new ModelPart[8];

    public RookfishModel(ModelPart root) {
        this.root = root.getChild("root");
        Arrays.setAll(this.legs, i -> root.getChild("root").getChild("leg" + (i + 1)));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        root.addOrReplaceChild("upper1", CubeListBuilder.create().texOffs(1, 26).addBox(-4.0f, -1.0f, 0.0f, 8.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)-4.0f, (float)0.2138f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("upper2", CubeListBuilder.create().texOffs(1, 26).addBox(-4.0f, -1.0f, 0.0f, 8.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)4.0f, (float)-0.2138f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("upper3", CubeListBuilder.create().texOffs(1, 18).addBox(0.0f, -1.0f, -4.0f, 0.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2138f));
        root.addOrReplaceChild("upper4", CubeListBuilder.create().texOffs(1, 18).addBox(0.0f, -1.0f, -4.0f, 0.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2138f));
        root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-2.0f));
        root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)2.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        root.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        root.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(24, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        root.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(24, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.6464f, (float)3.0f, (float)-1.6464f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        root.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.6464f, (float)3.0f, (float)-1.6464f, (float)0.0f, (float)0.7854f, (float)0.0f));
        root.addOrReplaceChild("leg7", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.6464f, (float)3.0f, (float)1.6464f, (float)0.0f, (float)2.3562f, (float)0.0f));
        root.addOrReplaceChild("leg8", CubeListBuilder.create().texOffs(24, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.6464f, (float)3.0f, (float)1.6464f, (float)0.0f, (float)-2.3562f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = Mth.frac((float)ageInTicks);
        float xBodyRot = Mth.lerp((float)partialTick, (float)((Rookfish)((Object)entity)).xBodyRotO, (float)((Rookfish)((Object)entity)).xBodyRot);
        float zBodyRot = Mth.lerp((float)partialTick, (float)((Rookfish)((Object)entity)).zBodyRotO, (float)((Rookfish)((Object)entity)).zBodyRot);
        this.root.xRot = -xBodyRot * ((float)Math.PI / 180);
        this.root.zRot = -zBodyRot * ((float)Math.PI / 180);
        for (ModelPart modelPart : this.legs) {
            modelPart.xRot = -Mth.lerp((float)partialTick, (float)((Rookfish)((Object)entity)).oldTentacleAngle, (float)((Rookfish)((Object)entity)).tentacleAngle);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

