/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookContext;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentConfig;
import cn.leolezury.eternalstarlight.common.client.book.text.BookContent;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IndexBookComponent
extends BookComponent<Config> {
    public IndexBookComponent() {
        super(Config.CODEC);
    }

    private List<Entry> filterEnabledEntries(Config config, BookContext context) {
        ArrayList<Entry> filtered = new ArrayList<Entry>(config.entries());
        filtered.removeIf(entry -> !context.isComponentEnabled(entry.jumpTo));
        return filtered;
    }

    @Override
    public int getTotalHeight(Config config, BookContext context) {
        int totalHeight = config.offset() + config.extraHeight();
        for (Entry entry : this.filterEnabledEntries(config, context)) {
            totalHeight += entry.getHeight(config, context);
        }
        return totalHeight;
    }

    @Override
    public void render(Config config, BookContext context, GuiGraphics graphics, int x, int y) {
        int startHeight = config.offset();
        for (Entry entry : this.filterEnabledEntries(config, context)) {
            entry.render(config, context, graphics, x, y + startHeight);
            startHeight += entry.getHeight(config, context);
        }
    }

    @Override
    public void onClick(Config config, BookContext context, int x, int y) {
        int startHeight = y + config.offset();
        for (Entry entry : this.filterEnabledEntries(config, context)) {
            int currentHeight = entry.getHeight(config, context);
            if (context.getMouseY() > startHeight && context.getMouseY() < startHeight + currentHeight) {
                context.jumpToComponent(entry.jumpTo);
                break;
            }
            startHeight += currentHeight;
        }
    }

    public record Config(ResourceLocation id, HashSet<HashSet<ResourceLocation>> unlockConditions, List<Entry> entries, int offset, int extraHeight, int width, int lineHeight) implements BookComponentConfig
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(Config::id), (App)ResourceLocation.CODEC.listOf().xmap(Sets::newHashSet, Lists::newArrayList).listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("unlock_conditions").forGetter(Config::unlockConditions), (App)Entry.CODEC.listOf().fieldOf("entries").forGetter(Config::entries), (App)Codec.INT.fieldOf("offset").forGetter(Config::offset), (App)Codec.INT.fieldOf("extra_height").forGetter(Config::extraHeight), (App)Codec.INT.fieldOf("width").forGetter(Config::width), (App)Codec.INT.fieldOf("line_height").forGetter(Config::lineHeight)).apply((Applicative)instance, Config::new));
    }

    public static class Entry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BookContent.CODEC.fieldOf("text").forGetter(o -> o.text), (App)ResourceLocation.CODEC.fieldOf("jump_to").forGetter(o -> o.jumpTo), (App)ResourceLocation.CODEC.listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("listening").forGetter(o -> o.listening), (App)Codec.INT.fieldOf("icon_frame_width").forGetter(o -> o.iconFrameWidth), (App)Codec.INT.fieldOf("icon_frame_height").forGetter(o -> o.iconFrameHeight), (App)ResourceLocation.CODEC.fieldOf("icon_frame").forGetter(o -> o.iconFrame), (App)CompoundTag.CODEC.fieldOf("icon").forGetter(o -> o.icon)).apply((Applicative)instance, Entry::new));
        private final BookContent text;
        private final ResourceLocation jumpTo;
        private final HashSet<ResourceLocation> listening;
        private final int iconFrameWidth;
        private final int iconFrameHeight;
        private final ResourceLocation iconFrame;
        private final CompoundTag icon;
        private ItemStack cachedIcon;

        public Entry(BookContent text, ResourceLocation jumpTo, HashSet<ResourceLocation> listening, int iconFrameWidth, int iconFrameHeight, ResourceLocation iconFrame, CompoundTag icon) {
            this.text = text;
            this.jumpTo = jumpTo;
            this.listening = listening;
            this.iconFrameWidth = iconFrameWidth;
            this.iconFrameHeight = iconFrameHeight;
            this.iconFrame = iconFrame;
            this.icon = icon;
        }

        public ResourceLocation getJumpToId() {
            return this.jumpTo;
        }

        public HashSet<ResourceLocation> getListeningIds() {
            return this.listening;
        }

        public Component getText() {
            return this.text.toComponent();
        }

        public ItemStack getIcon() {
            if (this.cachedIcon == null && Minecraft.getInstance().level != null) {
                this.cachedIcon = ItemStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)this.icon);
            }
            return this.cachedIcon == null ? ItemStack.EMPTY : this.cachedIcon;
        }

        private List<FormattedCharSequence> splitText(Config config, BookContext context, Component component) {
            return context.getFont().split((FormattedText)component, config.width() - this.iconFrameWidth - 5);
        }

        public int getHeight(Config config, BookContext context) {
            int n = (this.splitText(config, context, this.getText()).size() - 1) * config.lineHeight();
            Objects.requireNonNull(context.getFont());
            return Math.max(n + 9 / 2 + this.iconFrameHeight / 2, this.iconFrameHeight);
        }

        public void render(Config config, BookContext context, GuiGraphics graphics, int x, int y) {
            graphics.blit(this.iconFrame, x, y, 0.0f, 0.0f, this.iconFrameWidth, this.iconFrameHeight, this.iconFrameWidth, this.iconFrameHeight);
            graphics.renderItem(this.getIcon(), x + this.iconFrameWidth / 2 - 8, y + this.iconFrameHeight / 2 - 8);
            boolean selected = context.getMouseX() >= context.getContentX() && context.getMouseX() <= context.getContentX() + context.getBookDefinition().width() - 2 * context.getBookDefinition().frameWidth() && context.getMouseY() > y && context.getMouseY() < y + this.getHeight(config, context);
            List<FormattedCharSequence> list = this.splitText(config, context, (Component)(selected ? this.getText().copy().withStyle(ChatFormatting.UNDERLINE) : this.getText()));
            for (int i = 0; i < list.size(); ++i) {
                Font font = context.getFont();
                int n = y + this.iconFrameHeight / 2;
                Objects.requireNonNull(context.getFont());
                graphics.drawString(font, list.get(i), x + this.iconFrameWidth + 5, n - 9 / 2 + i * config.lineHeight(), -1, true);
            }
        }
    }
}

