/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.DisplayBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.IndexBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.MobInfoBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.TextBookComponent;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BookComponentRegistry {
    private static final Map<ResourceLocation, BookComponent<?>> COMPONENTS = new HashMap();
    public static final Codec<BookComponent<?>> BY_NAME_CODEC = ResourceLocation.CODEC.xmap(id -> BookComponentRegistry.get(id).orElseThrow(), BookComponentRegistry::getKey);
    public static final TextBookComponent TEXT = BookComponentRegistry.register("text", new TextBookComponent());
    public static final DisplayBookComponent DISPLAY = BookComponentRegistry.register("display", new DisplayBookComponent());
    public static final IndexBookComponent INDEX = BookComponentRegistry.register("index", new IndexBookComponent());
    public static final MobInfoBookComponent MOB_INFO = BookComponentRegistry.register("mob_info", new MobInfoBookComponent());

    private static <T extends BookComponent<?>> T register(String location, T type) {
        return BookComponentRegistry.register(EternalStarlight.id(location), type);
    }

    public static <T extends BookComponent<?>> T register(ResourceLocation location, T type) {
        COMPONENTS.put(location, type);
        return type;
    }

    public static Optional<BookComponent<?>> get(ResourceLocation location) {
        return Optional.ofNullable(COMPONENTS.get(location));
    }

    public static ResourceLocation getKey(BookComponent<?> type) {
        for (Map.Entry<ResourceLocation, BookComponent<?>> entry : COMPONENTS.entrySet()) {
            if (entry.getValue() != type) continue;
            return entry.getKey();
        }
        return ResourceLocation.withDefaultNamespace((String)"unregistered");
    }
}

