/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LumenstemBlock
extends GrowingPlantHeadBlock
implements LiquidBlockContainer {
    public static final MapCodec<LumenstemBlock> CODEC = LumenstemBlock.simpleCodec(LumenstemBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;

    public LumenstemBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, SHAPE, false, 0.02);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<LumenstemBlock> codec() {
        return CODEC;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource randomSource) {
        return 1;
    }

    protected boolean canGrowInto(BlockState state) {
        return state.is(Blocks.WATER);
    }

    protected Block getBodyBlock() {
        return (Block)ESBlocks.LUMENSTEM_PLANT.get();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState;
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            state = (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(!context.getLevel().getBlockState(context.getClickedPos().relative(this.growthDirection.getOpposite())).is(this.getBodyBlock())));
        }
        return (fluidState = context.getLevel().getFluidState(context.getClickedPos())).is(FluidTags.WATER) && fluidState.getAmount() == 8 ? state : null;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState newState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        return newState.hasProperty((Property)BOTTOM) ? (BlockState)newState.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(!level.getBlockState(pos.relative(this.growthDirection.getOpposite())).is(this.getBodyBlock()))) : newState;
    }

    public FluidState getFluidState(BlockState blockState) {
        return Fluids.WATER.getSource(false);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BOTTOM});
    }
}

