/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.rechiseled.screen.BlockCapture;
import com.supermartijn642.rechiseled.screen.BlockCaptureLevel;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ScreenBlockRenderer {
    private static final RandomSource RANDOM = RandomSource.create();
    private static BlockCaptureLevel fakeLevel;

    public static void drawBlock(PoseStack poseStack, BlockCapture capture, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AABB bounds = capture.getBounds();
        double span = Math.sqrt(bounds.getXsize() * bounds.getXsize() + bounds.getYsize() * bounds.getYsize() + bounds.getZsize() * bounds.getZsize());
        scale /= span;
        if (fakeLevel == null) {
            fakeLevel = new BlockCaptureLevel();
        }
        fakeLevel.setCapture(capture);
        poseStack.pushPose();
        poseStack.translate(x, y, 350.0);
        poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.scale((float)scale, (float)scale, (float)scale);
        poseStack.mulPose(new Quaternionf().setAngleAxis(pitch / 180.0f * (float)Math.PI, 1.0f, 0.0f, 0.0f));
        poseStack.mulPose(new Quaternionf().setAngleAxis(yaw / 180.0f * (float)Math.PI, 0.0f, 1.0f, 0.0f));
        if (doShading) {
            Lighting.setupForEntityInInventory((Quaternionf)new Quaternionf().rotateX(1.5707964f).rotateZ((float)Math.PI));
        }
        MultiBufferSource.BufferSource renderTypeBuffer = RenderUtils.getMainBufferSource();
        for (Map.Entry<BlockPos, BlockState> entry : capture.getBlocks()) {
            ScreenBlockRenderer.renderBlock(entry.getKey(), entry.getValue(), poseStack, (MultiBufferSource)renderTypeBuffer);
        }
        renderTypeBuffer.endBatch();
        RenderSystem.enableDepthTest();
        if (doShading) {
            Lighting.setupForFlatItems();
        }
        poseStack.popPose();
        fakeLevel.setCapture(null);
    }

    private static void renderBlock(BlockPos pos, BlockState state, PoseStack poseStack, MultiBufferSource renderTypeBuffer) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5);
        BakedModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
        ModelData modelData = model.getModelData((BlockAndTintGetter)fakeLevel, pos, state, ModelData.EMPTY);
        RANDOM.setSeed(42L);
        ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, RANDOM, modelData);
        for (RenderType renderType : renderTypes) {
            RenderType itemRenderType = renderType == RenderType.translucent() ? Sheets.translucentCullBlockSheet() : Sheets.cutoutBlockSheet();
            ScreenBlockRenderer.renderModel(model, state, poseStack, renderTypeBuffer.getBuffer(itemRenderType), modelData, renderType);
        }
        poseStack.popPose();
    }

    private static void renderModel(BakedModel modelIn, BlockState state, PoseStack matrixStackIn, VertexConsumer bufferIn, ModelData modelData, RenderType renderType) {
        for (Direction direction : Direction.values()) {
            RANDOM.setSeed(42L);
            ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, direction, RANDOM, modelData, renderType));
        }
        RANDOM.setSeed(42L);
        ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, null, RANDOM, modelData, renderType));
    }

    private static void renderQuads(PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn) {
        PoseStack.Pose matrix = matrixStackIn.last();
        for (BakedQuad bakedquad : quadsIn) {
            bufferIn.putBulkData(matrix, bakedquad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, false);
        }
    }
}

