/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor.enums;

import com.mojang.serialization.Codec;
import dev.worldgen.lithostitched.worldgen.processor.condition.ProcessorCondition;
import java.util.function.Function;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;

public enum BlockType implements StringRepresentable
{
    INPUT("input", data -> data.relative().state()),
    LOCATION("location", data -> data.absolute().state());

    public static final Codec<BlockType> CODEC;
    private final String name;
    private final Function<ProcessorCondition.Data, BlockState> state;

    private BlockType(String name, Function<ProcessorCondition.Data, BlockState> state) {
        this.name = name;
        this.state = state;
    }

    public BlockState state(ProcessorCondition.Data data) {
        return this.state.apply(data);
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(BlockType::values);
    }
}

