/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.util.weighted.WeightedList;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.block.Block;

public interface LithostitchedCodecs {
    public static final Codec<HolderSet<Block>> BLOCK_SET = RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK);
    public static final MapCodec<Float> CHANCE = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance");
    public static final Codec<InclusiveRange<Integer>> INT_RANGE = Codec.withAlternative((Codec)InclusiveRange.INT, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_inclusive").orElse((Object)Integer.MIN_VALUE).forGetter(InclusiveRange::minInclusive), (App)Codec.INT.fieldOf("max_inclusive").orElse((Object)Integer.MAX_VALUE).forGetter(InclusiveRange::maxInclusive)).apply((Applicative)instance, InclusiveRange::new)));

    public static <T> MapCodec<HolderSet<T>> registrySet(ResourceKey<Registry<T>> registry, String name) {
        return RegistryCodecs.homogeneousList(registry).fieldOf(name);
    }

    public static <T> Codec<List<T>> compactList(Codec<T> codec) {
        return Codec.withAlternative((Codec)codec.listOf(), codec, List::of);
    }

    public static <T> Codec<WeightedList<T>> compactWeightedList(Codec<T> codec, boolean allowsEmpty) {
        Codec<WeightedList<T>> weightedCodec = allowsEmpty ? WeightedList.codec(codec) : WeightedList.nonEmptyCodec(codec);
        return Codec.withAlternative(weightedCodec, codec, WeightedList::of);
    }
}

