/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.items.porter;

import java.util.function.Supplier;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.various.IItemCycler;
import mcjty.rftoolsutility.modules.teleporter.PorterTools;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.client.GuiAdvancedPorter;
import mcjty.rftoolsutility.modules.teleporter.data.ChargedPorterData;
import mcjty.rftoolsutility.modules.teleporter.items.porter.ChargedPorterItem;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AdvancedChargedPorterItem
extends ChargedPorterItem
implements IItemCycler {
    public static final int MAXTARGETS = 8;

    public AdvancedChargedPorterItem() {
        super((Supplier<Integer>)TeleportConfiguration.ADVANCED_CHARGEDPORTER_MAXENERGY);
    }

    public void cycle(Player player, ItemStack stack, boolean next) {
        PorterTools.cycleDestination(player, next, stack);
    }

    @Override
    protected int getSpeedBonus() {
        return (Integer)TeleportConfiguration.advancedSpeedBonus.get();
    }

    @Override
    protected ChargedPorterData selectOnReceiver(Player player, Level world, ChargedPorterData data, int id) {
        int i;
        for (i = 0; i < 8; ++i) {
            if (data.getTarget(i) != id) continue;
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "Receiver " + id + " was already added to the charged porter."));
            return data;
        }
        for (i = 0; i < 8; ++i) {
            if (data.getTarget(i) != -1) continue;
            if ((data = data.withTarget(i, id)).currentTarget() == -1) {
                data = data.withCurrentTarget(id);
            }
            Logging.message((Player)player, (String)("Receiver " + id + " is added to the charged porter."));
            return data;
        }
        Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "Charged porter has no free targets!"));
        return data;
    }

    @Override
    protected void selectReceiver(ItemStack stack, Level world, Player player) {
        if (world.isClientSide) {
            GuiAdvancedPorter.open();
        }
    }

    @Override
    protected ChargedPorterData selectOnThinAir(Player player, Level world, ChargedPorterData data, ItemStack stack) {
        this.selectReceiver(stack, world, player);
        return data;
    }
}

