/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter;

import java.util.UUID;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.varia.DamageTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.blocks.DialingDeviceTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.setup.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TeleportationTools {
    public static final int STATUS_OK = 0;
    public static final int STATUS_WARN = 1;
    public static final int STATUS_UNKNOWN = 2;
    public static MobEffect confusion;
    public static MobEffect harm;
    public static MobEffect wither;

    public static void getPotions() {
        if (confusion == null) {
            confusion = Tools.getEffect((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"nausea"));
            harm = Tools.getEffect((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"instant_damage"));
            wither = Tools.getEffect((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"wither"));
        }
    }

    public static void applyEffectForSeverity(Player player, int severity, boolean boostNeeded) {
        TeleportationTools.getPotions();
        switch (severity) {
            case 1: {
                if (!boostNeeded) break;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                player.hurt(DamageTools.getGenericDamageSource((Entity)player), 0.5f);
                break;
            }
            case 4: {
                player.hurt(DamageTools.getGenericDamageSource((Entity)player), 0.5f);
                break;
            }
            case 5: {
                player.hurt(DamageTools.getGenericDamageSource((Entity)player), 1.0f);
                break;
            }
            case 6: {
                player.hurt(DamageTools.getGenericDamageSource((Entity)player), 1.0f);
                break;
            }
            case 7: {
                player.hurt(DamageTools.getGenericDamageSource((Entity)player), 2.0f);
                break;
            }
            case 8: {
                player.hurt(DamageTools.getGenericDamageSource((Entity)player), 2.0f);
                break;
            }
            case 9: {
                player.hurt(DamageTools.getGenericDamageSource((Entity)player), 3.0f);
                break;
            }
            case 10: {
                player.hurt(DamageTools.getGenericDamageSource((Entity)player), 3.0f);
            }
        }
    }

    public static int calculateRFCost(Level world, BlockPos c1, TeleportDestination teleportDestination) {
        if (!world.dimension().equals(teleportDestination.getDimension())) {
            return (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get();
        }
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3((double)c1.getX(), (double)c1.getY(), (double)c1.getZ()).distanceTo(new Vec3((double)c2.getX(), (double)c2.getY(), (double)c2.getZ()));
        int rf = (Integer)TeleportConfiguration.rfStartTeleportBaseLocal.get() + (int)((double)((Integer)TeleportConfiguration.rfStartTeleportDist.get()).intValue() * dist);
        if (rf > (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get()) {
            rf = (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get();
        }
        return rf;
    }

    public static int calculateTime(Level world, BlockPos c1, TeleportDestination teleportDestination) {
        if (!world.dimension().equals(teleportDestination.getDimension())) {
            return (Integer)TeleportConfiguration.timeTeleportBaseDim.get();
        }
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3((double)c1.getX(), (double)c1.getY(), (double)c1.getZ()).distanceTo(new Vec3((double)c2.getX(), (double)c2.getY(), (double)c2.getZ()));
        int time = (Integer)TeleportConfiguration.timeTeleportBaseLocal.get() + (int)((double)((Integer)TeleportConfiguration.timeTeleportDist.get()).intValue() * dist / 1000.0);
        if (time > (Integer)TeleportConfiguration.timeTeleportBaseDim.get()) {
            time = (Integer)TeleportConfiguration.timeTeleportBaseDim.get();
        }
        return time;
    }

    public static boolean performTeleport(Player player, TeleportDestination dest, int bad, int good, boolean boosted) {
        BlockPos c = dest.getCoordinate();
        BlockPos old = new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ());
        ResourceKey oldId = player.getCommandSenderWorld().dimension();
        if (!TeleportationTools.allowTeleport((Entity)player, (ResourceKey<Level>)oldId, old, dest.getDimension(), dest.getCoordinate())) {
            return false;
        }
        if (!oldId.equals(dest.getDimension())) {
            mcjty.lib.varia.TeleportationTools.teleportToDimension((Player)player, dest.getDimension(), (double)((double)c.getX() + 0.5), (double)((double)c.getY() + 1.5), (double)((double)c.getZ() + 0.5));
        } else {
            player.teleportTo((double)c.getX() + 0.5, (double)(c.getY() + 1), (double)c.getZ() + 0.5);
        }
        if (((Boolean)TeleportConfiguration.whooshMessage.get()).booleanValue()) {
            Logging.message((Player)player, (String)"Whoosh!");
        }
        boolean boostNeeded = false;
        int severity = TeleportationTools.consumeReceiverEnergy(player, dest.getCoordinate(), dest.getDimension());
        if (severity > 0 && boosted) {
            boostNeeded = true;
            severity = 1;
        }
        if ((severity = TeleportationTools.applyBadEffectIfNeeded(player, severity, bad, good, boostNeeded)) <= 0 && (Double)TeleportConfiguration.teleportVolume.get() >= 0.01) {
            SoundTools.playSound((Level)player.getCommandSenderWorld(), (SoundEvent)ModSounds.WHOOSH.get(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (double)((Double)TeleportConfiguration.teleportVolume.get()), (double)1.0);
        }
        if (((Boolean)TeleportConfiguration.logTeleportUsages.get()).booleanValue()) {
            Logging.log((String)("Teleport: Player " + String.valueOf(player.getName()) + " from " + String.valueOf(old) + " (dim " + String.valueOf(oldId) + ") to " + String.valueOf(dest.getCoordinate()) + " (dim " + String.valueOf(dest.getDimension()) + ") with severity " + severity));
        }
        return boostNeeded;
    }

    public static int dial(Level worldObj, DialingDeviceTileEntity dialingDeviceTileEntity, UUID player, BlockPos transmitter, ResourceKey<Level> transDim, BlockPos coordinate, ResourceKey<Level> dimension, boolean once) {
        ServerLevel transWorld = LevelTools.getLevel(transDim);
        if (transWorld == null) {
            return 256;
        }
        MatterTransmitterTileEntity transmitterTileEntity = (MatterTransmitterTileEntity)transWorld.getBlockEntity(transmitter);
        if (transmitterTileEntity == null) {
            return 1024;
        }
        if (player != null && !transmitterTileEntity.checkAccess(player)) {
            return 32;
        }
        if (coordinate == null) {
            transmitterTileEntity.setTeleportDestination(null, false);
            return 128;
        }
        TeleportDestination teleportDestination = TeleportationTools.findDestination(worldObj, coordinate, dimension);
        if (teleportDestination == null) {
            return 4;
        }
        BlockPos c = teleportDestination.getCoordinate();
        ServerLevel recWorld = LevelTools.getLevel(teleportDestination.getDimension());
        if (recWorld == null && (recWorld = LevelTools.getLevel((Level)worldObj, teleportDestination.getDimension())) == null) {
            return 4;
        }
        BlockEntity tileEntity = recWorld.getBlockEntity(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            return 4;
        }
        MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)tileEntity;
        TeleportDestination destination = receiver.updateDestination();
        if (player != null && !destination.checkAccess((Level)recWorld, player)) {
            return 64;
        }
        if (!TeleportationTools.checkBeam(transmitter, (Level)transWorld, 1, 4, 2)) {
            return 2;
        }
        if (dialingDeviceTileEntity != null) {
            IEnergyStorage h = (IEnergyStorage)dialingDeviceTileEntity.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, dialingDeviceTileEntity.getBlockPos(), null);
            if (h != null) {
                int defaultCost = (Integer)TeleportConfiguration.rfPerDial.get();
                DefaultInfusable inf = dialingDeviceTileEntity.getInfusable();
                int cost = (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f);
                if (h.getEnergyStored() < cost) {
                    return 8;
                }
                ((GenericEnergyStorage)h).consumeEnergy((long)cost);
            } else {
                return 8;
            }
        }
        transmitterTileEntity.setTeleportDestination(teleportDestination, once);
        return 0;
    }

    private static int consumeReceiverEnergy(Player player, BlockPos c, ResourceKey<Level> dimension) {
        DefaultInfusable inf;
        ServerLevel world = LevelTools.getLevel((Level)player.level(), dimension);
        if (world == null) {
            Logging.warn((Player)player, (String)"Something went wrong with the destination!");
            return 0;
        }
        BlockEntity te = world.getBlockEntity(c);
        if (!(te instanceof MatterReceiverTileEntity)) {
            Logging.warn((Player)player, (String)"Something went wrong with the destination!");
            return 0;
        }
        MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)te;
        IEnergyStorage h = (IEnergyStorage)receiver.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, receiver.getBlockPos(), null);
        if (h == null) {
            Logging.warn((Player)player, (String)"The matter receiver has no power!");
            return 0;
        }
        int defaultCost = (Integer)TeleportConfiguration.rfPerTeleportReceiver.get();
        int rf = (int)((float)defaultCost * (2.0f - (inf = receiver.getInfusable()).getInfusedFactor()) / 2.0f);
        if (rf <= 0) {
            return 0;
        }
        int extracted = Math.min(rf, h.getEnergyStored());
        ((GenericEnergyStorage)h).consumeEnergy((long)rf);
        long remainingRf = ((GenericEnergyStorage)h).getEnergy();
        if (remainingRf <= 1L) {
            Logging.warn((Player)player, (String)"The matter receiver has run out of power!");
        } else if (remainingRf < (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get() / 10)) {
            Logging.warn((Player)player, (String)"The matter receiver is getting very low on power!");
        } else if (remainingRf < (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get() / 5)) {
            Logging.warn((Player)player, (String)"The matter receiver is getting low on power!");
        }
        return 10 - extracted * 10 / rf;
    }

    public static int calculateSeverity(int bad, int total) {
        if (total == 0) {
            total = 1;
        }
        int severity = bad * 10 / total;
        if (TeleportationTools.mustInterrupt(bad, total)) {
            severity += 2;
        }
        if (severity > 10) {
            severity = 10;
        }
        return severity;
    }

    public static int applyBadEffectIfNeeded(Player player, int severity, int bad, int total, boolean boostNeeded) {
        if (player == null) {
            return 0;
        }
        if ((severity += TeleportationTools.calculateSeverity(bad, total)) > 10) {
            severity = 10;
        }
        if (severity <= 0) {
            return 0;
        }
        if ((Double)TeleportConfiguration.teleportErrorVolume.get() >= 0.01) {
            SoundTools.playSound((Level)player.getCommandSenderWorld(), (SoundEvent)ModSounds.ERROR.get(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (double)((Double)TeleportConfiguration.teleportErrorVolume.get()), (double)1.0);
        }
        TeleportationTools.applyEffectForSeverity(player, severity, boostNeeded);
        return severity;
    }

    public static boolean mustInterrupt(int bad, int total) {
        return bad > total / 2;
    }

    public static boolean allowTeleport(Entity entity, ResourceKey<Level> sourceDim, BlockPos source, ResourceKey<Level> destDim, BlockPos dest) {
        return true;
    }

    public static TeleportDestination findDestination(Level worldObj, BlockPos coordinate, ResourceKey<Level> dimension) {
        TeleportDestinations destinations = TeleportDestinations.get(worldObj);
        return destinations.getDestination(coordinate, dimension);
    }

    public static boolean checkBeam(BlockPos c, Level world, int dy1, int dy2, int errory) {
        for (int dy = dy1; dy <= dy2; ++dy) {
            BlockPos pos = new BlockPos(c.getX(), c.getY() + dy, c.getZ());
            if (world.getBlockState(pos).isAir()) continue;
            if (dy > errory) break;
            return false;
        }
        return true;
    }

    public static boolean checkValidTeleport(Player player, ResourceKey<Level> srcId, ResourceKey<Level> dstId) {
        if (((Boolean)TeleportConfiguration.preventInterdimensionalTeleports.get()).booleanValue() && srcId.equals(dstId)) {
            Logging.warn((Player)player, (String)"Teleportation in the same dimension is not allowed!");
            return false;
        }
        if (TeleportConfiguration.getBlacklistedTeleportationDestinations().contains(dstId)) {
            Logging.warn((Player)player, (String)"Teleportation to that dimension is not allowed!");
            return false;
        }
        if (TeleportConfiguration.getBlacklistedTeleportationSources().contains(srcId)) {
            Logging.warn((Player)player, (String)"Teleportation from this dimension is not allowed!");
            return false;
        }
        return true;
    }
}

