/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.items.BaseItem;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.data.SyringeData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class SyringeItem
extends BaseItem {
    public static final int MAX_SYRINGE_MODEL_LEVEL = 5;
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.parameter((String)"level", this::getLevelString), TooltipBuilder.parameter((String)"mob", this::hasMob, SyringeItem::getMobName), TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"level", this::getLevelString), TooltipBuilder.parameter((String)"mob", this::hasMob, SyringeItem::getMobName)}));

    public SyringeItem() {
        super(RFToolsUtility.setup.defaultProperties().stacksTo(1));
    }

    private String getLevelString(ItemStack stack) {
        return Integer.toString(SyringeItem.getLevel(stack));
    }

    private boolean hasMob(ItemStack stack) {
        return SyringeItem.getMobId(stack) != null;
    }

    public static int getLevel(ItemStack stack) {
        SyringeData data = (SyringeData)stack.get(SpawnerModule.ITEM_SYRINGE_DATA);
        return data != null ? data.level() * 100 / (Integer)SpawnerConfiguration.maxMobInjections.get() : 0;
    }

    public static void initOverrides(SyringeItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"level"), (stack, world, livingEntity, seed) -> {
            SyringeData data = (SyringeData)stack.get(SpawnerModule.ITEM_SYRINGE_DATA);
            int level = data != null ? data.level() : 0;
            return level * 5 / (Integer)SpawnerConfiguration.maxMobInjections.get();
        });
    }

    public void appendHoverText(@Nonnull ItemStack itemStack, Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    @Nullable
    public static LivingEntity getEntityLivingFromClickedEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public static ItemStack createMobSyringe(ResourceLocation mobId) {
        ItemStack syringe = new ItemStack((ItemLike)SpawnerModule.SYRINGE.get());
        SyringeData data = new SyringeData(mobId, 0);
        syringe.set(SpawnerModule.ITEM_SYRINGE_DATA, (Object)data);
        return syringe;
    }

    public static ResourceLocation getMobId(ItemStack stack) {
        SyringeData data = (SyringeData)stack.get(SpawnerModule.ITEM_SYRINGE_DATA);
        return data != null ? data.mob() : null;
    }

    public static String getMobName(ItemStack stack) {
        ResourceLocation id = SyringeItem.getMobId(stack);
        if (id == null) {
            return null;
        }
        EntityType type = Tools.getEntity((ResourceLocation)id);
        if (type != null) {
            return type.getDescription().getString();
        }
        return id.toString();
    }

    public List<ItemStack> getItemsForTab() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack((ItemLike)this));
        for (Map.Entry entry : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            if (((EntityType)entry.getValue()).getCategory() == MobCategory.MISC) continue;
            items.add(SyringeItem.createMobSyringe(id));
        }
        return items;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            SyringeData data = (SyringeData)stack.get(SpawnerModule.ITEM_SYRINGE_DATA);
            if (data != null) {
                String mobName = SyringeItem.getMobName(stack);
                if (mobName != null) {
                    Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.BLUE) + "Mob: " + mobName));
                }
                int level = data.level() == -1 ? ((Integer)SpawnerConfiguration.maxMobInjections.get()).intValue() : data.level();
                level = level * 100 / (Integer)SpawnerConfiguration.maxMobInjections.get();
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.BLUE) + "Essence level: " + level + "%"));
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity entityLiving = SyringeItem.getEntityLivingFromClickedEntity(entity);
        if (entityLiving != null) {
            ResourceLocation prevMobId = null;
            SyringeData data = (SyringeData)stack.get(SpawnerModule.ITEM_SYRINGE_DATA);
            if (data != null) {
                prevMobId = data.mob();
            } else {
                data = new SyringeData(null, 0);
            }
            ResourceLocation id = this.findSelectedMobId((Entity)entityLiving);
            if (id != null) {
                if (!id.equals((Object)prevMobId)) {
                    data = data.withMob(id).withLevel(1);
                } else {
                    int level = data.level();
                    if (level == -1) {
                        level = 0;
                    }
                    level = Math.min(level + 1, (Integer)SpawnerConfiguration.maxMobInjections.get());
                    data = data.withLevel(level);
                }
                stack.set(SpawnerModule.ITEM_SYRINGE_DATA, (Object)data);
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private ResourceLocation findSelectedMobId(Entity entity) {
        return Tools.getId((EntityType)entity.getType());
    }
}

