/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mcjty.lib.client.RenderGlowEffect;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.blocks.MatterBeamerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MatterBeamerRenderer
implements BlockEntityRenderer<MatterBeamerTileEntity> {
    public static final ResourceLocation REDGLOW = ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/effects/redglow");
    public static final ResourceLocation BLUEGLOW = ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/effects/blueglow");
    public static final Vec3 START = new Vec3(0.5, 0.5, 0.5);

    public MatterBeamerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MatterBeamerTileEntity tileEntity, float v, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i, int i1) {
        BlockPos coord;
        Object txt;
        BlockPos destination = tileEntity.getDestination();
        if (destination != null && tileEntity.isGlowing()) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(REDGLOW);
            VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
            int tex = tileEntity.getBlockPos().getX();
            int tey = tileEntity.getBlockPos().getY();
            int tez = tileEntity.getBlockPos().getZ();
            Vec3 player = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().add((double)(-tex), (double)(-tey), (double)(-tez));
            Vec3 end = new Vec3((double)((float)(destination.getX() - tex) + 0.5f), (double)((float)(destination.getY() - tey) + 0.5f), (double)((float)(destination.getZ() - tez) + 0.5f));
            RenderHelper.drawBeam((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vec3)START, (Vec3)end, (Vec3)player, (float)(tileEntity.isGlowing() ? 0.1f : 0.05f));
        }
        if ((txt = (coord = tileEntity.getBlockPos()).equals((Object)RFToolsBase.instance.clientInfo.getSelectedTE()) ? REDGLOW : (coord.equals((Object)RFToolsBase.instance.clientInfo.getDestinationTE()) ? BLUEGLOW : null)) != null) {
            RenderGlowEffect.renderGlow((PoseStack)matrixStack, (MultiBufferSource)buffer, (ResourceLocation)txt);
        }
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)SpawnerModule.MATTER_BEAMER.be().get()), MatterBeamerRenderer::new);
    }

    public AABB getRenderBoundingBox(MatterBeamerTileEntity be) {
        int xCoord = be.getBlockPos().getX();
        int yCoord = be.getBlockPos().getY();
        int zCoord = be.getBlockPos().getZ();
        return new AABB((double)(xCoord - 4), (double)(yCoord - 4), (double)(zCoord - 4), (double)(xCoord + 5), (double)(yCoord + 5), (double)(zCoord + 5));
    }
}

