/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record MachineInformationScreenModule(int tag, GlobalPos pos, boolean active, int labcolor, int txtcolor, String monitor) implements IScreenModule<MachineInformationScreenModule, IModuleDataString>
{
    public static final MachineInformationScreenModule DEFAULT = new MachineInformationScreenModule(0, GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID), false, 0xFFFFFF, 0xFFFFFF, "");
    public static final Codec<MachineInformationScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tag").forGetter(module -> module.tag), (App)GlobalPos.CODEC.fieldOf("pos").forGetter(module -> module.pos), (App)Codec.INT.fieldOf("labcolor").forGetter(module -> module.labcolor), (App)Codec.INT.fieldOf("txtcolor").forGetter(module -> module.txtcolor), (App)Codec.STRING.fieldOf("monitor").forGetter(module -> module.monitor)).apply((Applicative)instance, MachineInformationScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MachineInformationScreenModule> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, module -> module.tag, (StreamCodec)GlobalPos.STREAM_CODEC, module -> module.pos, (StreamCodec)ByteBufCodecs.INT, module -> module.labcolor, (StreamCodec)ByteBufCodecs.INT, module -> module.txtcolor, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.monitor, MachineInformationScreenModule::new);

    public MachineInformationScreenModule(int tag, GlobalPos pos, int labcolor, int txtcolor, String monitor) {
        this(tag, pos, false, labcolor, txtcolor, monitor);
    }

    public int getTag() {
        return this.tag;
    }

    public int getLabcolor() {
        return this.labcolor;
    }

    public int getTxtcolor() {
        return this.txtcolor;
    }

    public GlobalPos getPos() {
        return this.pos;
    }

    public String getMonitor() {
        return this.monitor;
    }

    public MachineInformationScreenModule withLabcolor(int labcolor) {
        return new MachineInformationScreenModule(this.tag, this.pos, this.active, labcolor, this.txtcolor, this.monitor);
    }

    public MachineInformationScreenModule withTxtcolor(int txtcolor) {
        return new MachineInformationScreenModule(this.tag, this.pos, this.active, this.labcolor, txtcolor, this.monitor);
    }

    public MachineInformationScreenModule withMonitor(String monitor) {
        return new MachineInformationScreenModule(this.tag, this.pos, this.active, this.labcolor, this.txtcolor, monitor);
    }

    public MachineInformationScreenModule withTag(int tag) {
        return new MachineInformationScreenModule(tag, this.pos, this.active, this.labcolor, this.txtcolor, this.monitor);
    }

    public MachineInformationScreenModule withPos(GlobalPos pos) {
        return new MachineInformationScreenModule(this.tag, pos, this.active, this.labcolor, this.txtcolor, this.monitor);
    }

    public MachineInformationScreenModule withActive(boolean active) {
        return new MachineInformationScreenModule(this.tag, this.pos, active, this.labcolor, this.txtcolor, this.monitor);
    }

    public IModuleDataString getData(IScreenDataHelper helper, Level worldObj, long millis) {
        if (!this.active) {
            return null;
        }
        ServerLevel world = LevelTools.getLevel((Level)worldObj, (ResourceKey)this.pos.dimension());
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.pos.pos())) {
            return null;
        }
        BlockEntity te = world.getBlockEntity(this.pos.pos());
        if (te == null) {
            return null;
        }
        IMachineInformation h = (IMachineInformation)te.getLevel().getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY, te.getBlockPos(), null);
        if (h != null) {
            String info = this.tag < 0 || this.tag >= h.getTagCount() ? "[BAD TAG]" : h.getData(this.tag, millis);
            return helper.createString(info);
        }
        return null;
    }

    public MachineInformationScreenModule validate(Level world, BlockPos p, boolean isPlus) {
        if (isPlus) {
            return this.withActive(true);
        }
        if (LevelTools.isLoaded((Level)world, (BlockPos)this.pos.pos()) && Objects.equals(this.pos.dimension(), world.dimension())) {
            int dx = Math.abs(this.pos.pos().getX() - p.getX());
            int dy = Math.abs(this.pos.pos().getY() - p.getY());
            int dz = Math.abs(this.pos.pos().getZ() - p.getZ());
            if (dx <= 64 && dy <= 64 && dz <= 64) {
                return this.withActive(true);
            }
        }
        return this.withActive(false);
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.MACHINEINFO_RFPERTICK.get();
    }

    public ItemStack mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked, Player player) {
        return ItemStack.EMPTY;
    }
}

