/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ScreenHitTileEntity
extends GenericTileEntity {
    private int dx;
    private int dy;
    private int dz;

    public ScreenHitTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ScreenModule.SCREEN_HIT.be().get(), pos, state);
    }

    public void setRelativeLocation(int dx, int dy, int dz) {
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.setChanged();
        BlockState state = this.getLevel().getBlockState(this.getBlockPos());
        this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
    }

    public int getDx() {
        return this.dx;
    }

    public int getDy() {
        return this.dy;
    }

    public int getDz() {
        return this.dz;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.dx = tag.getInt("dx");
        this.dy = tag.getInt("dy");
        this.dz = tag.getInt("dz");
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("dx", this.dx);
        tag.putInt("dy", this.dy);
        tag.putInt("dz", this.dz);
    }

    public void loadClientDataFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        this.dx = tag.getInt("dx");
        this.dy = tag.getInt("dy");
        this.dz = tag.getInt("dz");
    }

    public void saveClientDataToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("dx", this.dx);
        tag.putInt("dy", this.dy);
        tag.putInt("dz", this.dz);
    }
}

