/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.rftoolsutility.modules.logic.tools.AreaType;
import mcjty.rftoolsutility.modules.logic.tools.GroupType;
import mcjty.rftoolsutility.modules.logic.tools.SensorType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record SensorData(int number, SensorType sensorType, AreaType areaType, GroupType groupType) {
    public static final Codec<SensorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("number").forGetter(SensorData::number), (App)SensorType.CODEC.fieldOf("sensorType").forGetter(SensorData::sensorType), (App)AreaType.CODEC.fieldOf("areaType").forGetter(SensorData::areaType), (App)GroupType.CODEC.fieldOf("groupType").forGetter(SensorData::groupType)).apply((Applicative)instance, SensorData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SensorData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SensorData::number, SensorType.STREAM_CODEC, SensorData::sensorType, AreaType.STREAM_CODEC, SensorData::areaType, GroupType.STREAM_CODEC, SensorData::groupType, SensorData::new);

    public static SensorData createDefault() {
        return new SensorData(0, SensorType.SENSOR_BLOCK, AreaType.AREA_1, GroupType.GROUP_ONE);
    }

    public SensorData withNumber(int number) {
        return new SensorData(number, this.sensorType, this.areaType, this.groupType);
    }

    public SensorData withSensorType(SensorType sensorType) {
        return new SensorData(this.number, sensorType, this.areaType, this.groupType);
    }

    public SensorData withAreaType(AreaType areaType) {
        return new SensorData(this.number, this.sensorType, areaType, this.groupType);
    }

    public SensorData withGroupType(GroupType groupType) {
        return new SensorData(this.number, this.sensorType, this.areaType, groupType);
    }
}

