/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.world;

import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.event.handler.EventManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.level.PistonEvent;

public class PistonCrafting {
    public PistonCrafting() {
        EventManager.forge(PistonEvent.Pre.class).process(pre -> {
            BlockPos targetPos = pre.getPos().relative(pre.getDirection(), 2);
            BlockState targetBlockState = pre.getLevel().getBlockState(targetPos);
            if (targetBlockState.is(SushiContent.Tags.PRESSING_BASE)) {
                NonNullList list = NonNullList.create();
                LevelAccessor level = pre.getLevel();
                AABB aabb = new AABB(pre.getPos().relative(pre.getDirection(), 1));
                List entities = level.getEntitiesOfClass(ItemEntity.class, aabb, EntitySelector.ENTITY_STILL_ALIVE);
                for (ItemEntity entity : entities) {
                    if (!entity.getItem().is(Items.DRIED_KELP_BLOCK)) continue;
                    list.add((Object)new ItemStack((ItemLike)SushiContent.Items.NORI_SHEET.get(), (5 + pre.getLevel().getRandom().nextInt(4)) * entity.getItem().getCount()));
                    entity.remove(Entity.RemovalReason.KILLED);
                }
                if (!list.isEmpty()) {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.playSeededSound(null, (double)pre.getPos().getX(), (double)pre.getPos().getY(), (double)pre.getPos().getZ(), SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 0.75f, 1.0f, serverLevel.random.nextLong());
                    }
                    Containers.dropContents((Level)((Level)pre.getLevel()), (BlockPos)pre.getFaceOffsetPos().offset(0, 0, 0), (NonNullList)list);
                }
            }
        }).subscribe();
    }
}

