/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.proxy;

import com.buuz135.sushigocrafting.SushiGoCrafting;
import com.buuz135.sushigocrafting.block.machinery.CoolerBoxBlock;
import com.buuz135.sushigocrafting.block.machinery.CuttingBoardBlock;
import com.buuz135.sushigocrafting.block.machinery.FermentationBarrelBlock;
import com.buuz135.sushigocrafting.block.machinery.RiceCookerBlock;
import com.buuz135.sushigocrafting.block.machinery.RollerBlock;
import com.buuz135.sushigocrafting.block.plant.AvocadoLeavesBlock;
import com.buuz135.sushigocrafting.block.plant.AvocadoLogBlock;
import com.buuz135.sushigocrafting.block.plant.CustomCropBlock;
import com.buuz135.sushigocrafting.block.plant.WaterCropBlock;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.entity.ShrimpEntity;
import com.buuz135.sushigocrafting.entity.TunaEntity;
import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.item.SushiItem;
import com.buuz135.sushigocrafting.loot.ItemAmountLootModifier;
import com.buuz135.sushigocrafting.loot.SeedsLootModifier;
import com.buuz135.sushigocrafting.potioneffect.AcquiredTasteEffect;
import com.buuz135.sushigocrafting.potioneffect.SmallBitesEffect;
import com.buuz135.sushigocrafting.potioneffect.SteadyHandsEffect;
import com.buuz135.sushigocrafting.recipe.CombineAmountItemRecipe;
import com.buuz135.sushigocrafting.recipe.CuttingBoardRecipe;
import com.buuz135.sushigocrafting.recipe.FermentingBarrelRecipe;
import com.buuz135.sushigocrafting.tile.machinery.CoolerBoxTile;
import com.buuz135.sushigocrafting.tile.machinery.CuttingBoardTile;
import com.buuz135.sushigocrafting.tile.machinery.FermentationBarrelTile;
import com.buuz135.sushigocrafting.tile.machinery.RiceCookerTile;
import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.hrznstudio.titanium.recipe.serializer.GenericSerializer;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SushiContent {
    public static <T extends Block> DeferredHolder<Block, T> block(String id, Supplier<T> block) {
        return Blocks.REGISTRY.register(id, block);
    }

    public static DeferredHolder<Item, Item> item(String id, Supplier<Item> item) {
        return Items.REGISTRY.register(id, () -> {
            Item i = (Item)item.get();
            return i;
        });
    }

    public static DeferredHolder<Item, Item> basicItem(String id, String category) {
        return Items.REGISTRY.register(id, () -> new SushiItem(new Item.Properties(), category));
    }

    public static DeferredHolder<Item, AmountItem> amountItem(String id, String category, int minAmount, int maxAmount, int maxCombine, boolean hurts) {
        return Items.REGISTRY.register(id, () -> {
            AmountItem item = new AmountItem(new Item.Properties().stacksTo(1), category, minAmount, maxAmount, maxCombine, hurts);
            return item;
        });
    }

    public static DeferredHolder<Item, BlockItem> blockItem(String id, Supplier<? extends Block> sup) {
        return Items.REGISTRY.register(id, () -> {
            BlockItem blockItem = new BlockItem((Block)sup.get(), new Item.Properties());
            SushiGoCrafting.TAB.getTabList().add(blockItem);
            return blockItem;
        });
    }

    public static DeferredHolder<Item, BlockItem> blockItem(String id, Supplier<? extends Block> sup, Item.Properties properties) {
        return Items.REGISTRY.register(id, () -> {
            BlockItem blockItem = new BlockItem((Block)sup.get(), properties);
            SushiGoCrafting.TAB.getTabList().add(blockItem);
            return blockItem;
        });
    }

    public static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> tile(String id, BlockEntityType.BlockEntitySupplier<T> supplier, Supplier<? extends Block> sup) {
        return TileEntities.REGISTRY.register(id, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{(Block)sup.get()}).build(null));
    }

    public static DeferredHolder<MobEffect, MobEffect> effect(String id, Supplier<MobEffect> supplier) {
        return Effects.REGISTRY.register(id, supplier);
    }

    public static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> entity(String id, Supplier<EntityType<T>> supplier) {
        return EntityTypes.REGISTRY.register(id, supplier);
    }

    public static <T extends IGlobalLootModifier> DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<T>> lootSerializer(String id, Supplier<MapCodec<T>> supplier) {
        return LootSerializers.REGISTRY.register(id, supplier);
    }

    public static DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> recipeSerializer(String id, Supplier<RecipeSerializer<?>> supplier) {
        return RecipeSerializers.REGISTRY.register(id, supplier);
    }

    public static DeferredHolder<RecipeType<?>, RecipeType<?>> recipeType(String id, Supplier<RecipeType<?>> supplier) {
        return RecipeTypes.REGISTRY.register(id, supplier);
    }

    public static class Blocks {
        public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"sushigocrafting");
        public static final DeferredHolder<Block, CustomCropBlock> RICE_CROP = SushiContent.block("rice_crop", () -> new WaterCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.KELP_PLANT), (Supplier<? extends Item>)Items.RICE_SEEDS, state -> state.is(net.minecraft.world.level.block.Blocks.DIRT)));
        public static final DeferredHolder<Block, CustomCropBlock> CUCUMBER_CROP = SushiContent.block("cucumber_crop", () -> new CustomCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.WHEAT), (Supplier<? extends Item>)Items.CUCUMBER_SEEDS, state -> state.is(net.minecraft.world.level.block.Blocks.FARMLAND)));
        public static final DeferredHolder<Block, CustomCropBlock> SOY_CROP = SushiContent.block("soy_crop", () -> new CustomCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.WHEAT), (Supplier<? extends Item>)Items.SOY_SEEDS, state -> state.is(net.minecraft.world.level.block.Blocks.FARMLAND)));
        public static final DeferredHolder<Block, CustomCropBlock> WASABI_CROP = SushiContent.block("wasabi_crop", () -> new CustomCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.WHEAT), (Supplier<? extends Item>)Items.WASABI_SEEDS, state -> state.is(net.minecraft.world.level.block.Blocks.FARMLAND)));
        public static final DeferredHolder<Block, CustomCropBlock> SESAME_CROP = SushiContent.block("sesame_crop", () -> new CustomCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.WHEAT), (Supplier<? extends Item>)Items.SESAME_SEEDS, state -> state.is(net.minecraft.world.level.block.Blocks.FARMLAND)));
        public static final DeferredHolder<Block, RotatedPillarBlock> AVOCADO_LOG = SushiContent.block("avocado_log", () -> new AvocadoLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.OAK_WOOD)));
        public static final DeferredHolder<Block, RotatedPillarBlock> AVOCADO_LEAVES_LOG = SushiContent.block("avocado_leaves_logged", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.OAK_WOOD).noOcclusion()));
        public static final DeferredHolder<Block, Block> AVOCADO_LEAVES = SushiContent.block("avocado_leaves", AvocadoLeavesBlock::new);
        public static final DeferredHolder<Block, Block> AVOCADO_SAPLING = SushiContent.block("avocado_sapling", () -> new SaplingBlock(new TreeGrower("avocado", Optional.empty(), Optional.of(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"avocado_tree"))), Optional.empty()), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.OAK_SAPLING)));
        public static final DeferredHolder<Block, RollerBlock> ROLLER = SushiContent.block("roller", RollerBlock::new);
        public static final DeferredHolder<Block, RiceCookerBlock> RICE_COOKER = SushiContent.block("rice_cooker", RiceCookerBlock::new);
        public static final DeferredHolder<Block, CuttingBoardBlock> CUTTING_BOARD = SushiContent.block("cutting_board", CuttingBoardBlock::new);
        public static final DeferredHolder<Block, CoolerBoxBlock> COOLER_BOX = SushiContent.block("cooler_box", CoolerBoxBlock::new);
        public static final DeferredHolder<Block, FermentationBarrelBlock> FERMENTATION_BARREL = SushiContent.block("fermentation_barrel", FermentationBarrelBlock::new);
    }

    public static class Items {
        public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"sushigocrafting");
        public static final DeferredHolder<Item, BlockItem> RICE_SEEDS = SushiContent.blockItem("rice_seeds", Blocks.RICE_CROP);
        public static final DeferredHolder<Item, Item> RICE = SushiContent.basicItem("rice", "plant");
        public static final DeferredHolder<Item, BlockItem> CUCUMBER_SEEDS = SushiContent.blockItem("cucumber_seeds", Blocks.CUCUMBER_CROP);
        public static final DeferredHolder<Item, Item> CUCUMBER = SushiContent.basicItem("cucumber", "plant");
        public static final DeferredHolder<Item, BlockItem> SOY_SEEDS = SushiContent.blockItem("soy_seeds", Blocks.SOY_CROP);
        public static final DeferredHolder<Item, Item> SOY_BEAN = SushiContent.basicItem("soy_bean", "plant");
        public static final DeferredHolder<Item, BlockItem> WASABI_SEEDS = SushiContent.blockItem("wasabi_seeds", Blocks.WASABI_CROP);
        public static final DeferredHolder<Item, Item> WASABI_ROOT = SushiContent.basicItem("wasabi_root", "plant");
        public static final DeferredHolder<Item, BlockItem> SESAME_SEEDS = SushiContent.blockItem("sesame_seeds", Blocks.SESAME_CROP);
        public static final DeferredHolder<Item, Item> SEAWEED_ON_A_STICK = SushiContent.basicItem("seaweed_on_a_stick", "");
        public static final DeferredHolder<Item, Item> RAW_TUNA = SushiContent.basicItem("raw_tuna", "");
        public static final DeferredHolder<Item, Item> AVOCADO = SushiContent.basicItem("avocado", "plant");
        public static final DeferredHolder<Item, BlockItem> AVOCADO_LOG = SushiContent.blockItem("avocado_log", Blocks.AVOCADO_LOG);
        public static final DeferredHolder<Item, BlockItem> AVOCADO_LEAVES = SushiContent.blockItem("avocado_leaves", Blocks.AVOCADO_LEAVES);
        public static final DeferredHolder<Item, BlockItem> AVOCADO_LEAVES_LOG = SushiContent.blockItem("avocado_leaves_logged", Blocks.AVOCADO_LEAVES_LOG);
        public static final DeferredHolder<Item, BlockItem> AVOCADO_SAPLING = SushiContent.blockItem("avocado_sapling", Blocks.AVOCADO_SAPLING);
        public static final DeferredHolder<Item, BlockItem> ROLLER = SushiContent.blockItem("roller", Blocks.ROLLER);
        public static final DeferredHolder<Item, BlockItem> RICE_COOKER = SushiContent.blockItem("rice_cooker", Blocks.RICE_COOKER);
        public static final DeferredHolder<Item, BlockItem> CUTTING_BOARD = SushiContent.blockItem("cutting_board", Blocks.CUTTING_BOARD);
        public static final DeferredHolder<Item, BlockItem> COOLER_BOX = SushiContent.blockItem("cooler_box", Blocks.COOLER_BOX, new Item.Properties().stacksTo(1));
        public static final DeferredHolder<Item, BlockItem> FERMENTATION_BARREL = SushiContent.blockItem("fermentation_barrel", Blocks.FERMENTATION_BARREL);
        public static final DeferredHolder<Item, AmountItem> AVOCADO_SLICES = SushiContent.amountItem("avocado_slices", "ingredient", 100, 500, 1000, false);
        public static final DeferredHolder<Item, AmountItem> RAW_TUNA_FILLET = SushiContent.amountItem("tuna_fillet", "ingredient", 1000, 3000, 6000, false);
        public static final DeferredHolder<Item, AmountItem> RAW_SALMON_FILLET = SushiContent.amountItem("salmon_fillet", "ingredient", 500, 2000, 4000, false);
        public static final DeferredHolder<Item, Item> NORI_SHEET = SushiContent.basicItem("nori_sheets", "ingredient");
        public static final DeferredHolder<Item, AmountItem> COOKED_RICE = SushiContent.amountItem("cooked_rice", "ingredient", 50, 500, 2000, false);
        public static final DeferredHolder<Item, AmountItem> CUCUMBER_SLICES = SushiContent.amountItem("cucumber_slices", "ingredient", 50, 200, 400, false);
        public static final DeferredHolder<Item, AmountItem> IMITATION_CRAB = SushiContent.amountItem("imitation_crab", "ingredient", 50, 200, 400, false);
        public static final DeferredHolder<Item, AmountItem> SESAME_SEED = SushiContent.amountItem("sesame_seed", "ingredient", 10, 100, 200, false);
        public static final DeferredHolder<Item, AmountItem> TOBIKO = SushiContent.amountItem("tobiko", "ingredient", 10, 50, 100, false);
        public static final DeferredHolder<Item, AmountItem> CHEESE = SushiContent.amountItem("cheese", "ingredient", 50, 250, 500, false);
        public static final DeferredHolder<Item, AmountItem> SHRIMP = SushiContent.amountItem("shrimp", "ingredient", 20, 50, 100, false);
        public static final DeferredHolder<Item, AmountItem> SOY_SAUCE = SushiContent.amountItem("soy_sauce", "ingredient", 10, 50, 100, true);
        public static final DeferredHolder<Item, AmountItem> WASABI_PASTE = SushiContent.amountItem("wasabi_paste", "ingredient", 10, 50, 100, true);
        public static final DeferredHolder<Item, Item> KNIFE_CLEAVER = SushiContent.basicItem("cleaver_knife", "");
        public static final DeferredHolder<Item, Item> TUNA_BUCKET = SushiContent.item("tuna_bucket", () -> new MobBucketItem((EntityType)EntityTypes.TUNA.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().stacksTo(1)));
        public static final DeferredHolder<Item, Item> SHRIMP_BUCKET = SushiContent.item("shrimp_bucket", () -> new MobBucketItem((EntityType)EntityTypes.SHRIMP.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_AXOLOTL, new Item.Properties().stacksTo(1)));
    }

    public static class TileEntities {
        public static final DeferredRegister<BlockEntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"sushigocrafting");
        public static DeferredHolder<BlockEntityType<?>, BlockEntityType<RollerTile>> ROLLER = SushiContent.tile("roller", RollerTile::new, Blocks.ROLLER);
        public static DeferredHolder<BlockEntityType<?>, BlockEntityType<RiceCookerTile>> RICE_COOKER = SushiContent.tile("rice_cooker", RiceCookerTile::new, Blocks.RICE_COOKER);
        public static DeferredHolder<BlockEntityType<?>, BlockEntityType<CuttingBoardTile>> CUTTING_BOARD = SushiContent.tile("cutting_board", CuttingBoardTile::new, Blocks.CUTTING_BOARD);
        public static DeferredHolder<BlockEntityType<?>, BlockEntityType<CoolerBoxTile>> COOLER_BOX = SushiContent.tile("cooler_box", CoolerBoxTile::new, Blocks.COOLER_BOX);
        public static DeferredHolder<BlockEntityType<?>, BlockEntityType<FermentationBarrelTile>> FERMENTATION_BARREL = SushiContent.tile("fermentation_barrel", FermentationBarrelTile::new, Blocks.FERMENTATION_BARREL);
    }

    public static class Effects {
        public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"sushigocrafting");
        public static final DeferredHolder<MobEffect, MobEffect> ACQUIRED_TASTE = SushiContent.effect("acquired_taste", AcquiredTasteEffect::new);
        public static final DeferredHolder<MobEffect, MobEffect> SMALL_BITES = SushiContent.effect("small_bites", SmallBitesEffect::new);
        public static final DeferredHolder<MobEffect, MobEffect> STEADY_HANDS = SushiContent.effect("steady_hands", SteadyHandsEffect::new);
    }

    public static class EntityTypes {
        public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"sushigocrafting");
        public static final DeferredHolder<EntityType<?>, EntityType<TunaEntity>> TUNA = SushiContent.entity("tuna", () -> EntityType.Builder.of(TunaEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.7f, 0.4f).clientTrackingRange(4).build("tuna"));
        public static final DeferredHolder<EntityType<?>, EntityType<ShrimpEntity>> SHRIMP = SushiContent.entity("shrimp", () -> EntityType.Builder.of(ShrimpEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.7f, 0.4f).clientTrackingRange(4).build("shrimp"));

        public static DeferredHolder<EntityType<?>, EntityType<TunaEntity>> getTuna() {
            return TUNA;
        }

        public static DeferredHolder<EntityType<?>, EntityType<ShrimpEntity>> getShrimp() {
            return SHRIMP;
        }
    }

    public static class LootSerializers {
        public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> REGISTRY = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"sushigocrafting");
        public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<SeedsLootModifier>> SEEDS = SushiContent.lootSerializer("grass_seeds", () -> SeedsLootModifier.CODEC);
        public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<ItemAmountLootModifier>> ITEM_AMOUNT = SushiContent.lootSerializer("item_amount", () -> ItemAmountLootModifier.CODEC);
    }

    public static class RecipeSerializers {
        public static final DeferredRegister<RecipeSerializer<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"sushigocrafting");
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> COMBINE_AMOUNT = SushiContent.recipeSerializer("amount_combine_recipe", () -> new SimpleCraftingRecipeSerializer(craftingBookCategory -> new CombineAmountItemRecipe()));
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> CUTTING_BOARD = SushiContent.recipeSerializer("cutting_board", () -> new GenericSerializer(CuttingBoardRecipe.class, RecipeTypes.CUTTING_BOARD, CuttingBoardRecipe.CODEC));
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> FERMENTING_BARREL = SushiContent.recipeSerializer("fermenting_barrel", () -> new GenericSerializer(FermentingBarrelRecipe.class, RecipeTypes.FERMENTING_BARREL, FermentingBarrelRecipe.CODEC));
    }

    public static class RecipeTypes {
        public static final DeferredRegister<RecipeType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"sushigocrafting");
        public static final DeferredHolder<RecipeType<?>, RecipeType<?>> CUTTING_BOARD = SushiContent.recipeType("cutting_board", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"cutting_board")));
        public static final DeferredHolder<RecipeType<?>, RecipeType<?>> FERMENTING_BARREL = SushiContent.recipeType("fermenting_barrel", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"fermenting_barrel")));
    }

    public static class Tags {
        public static final TagKey<Block> PRESSING_BASE = BlockTags.create((ResourceLocation)ResourceLocation.tryBuild((String)"sushigocrafting", (String)"pressing_base"));
    }

    public static class AttachmentTypes {
        public static final DeferredRegister<AttachmentType<?>> REGISTRY = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"sushigocrafting");
        public static final DeferredHolder<AttachmentType<?>, AttachmentType<SushiWeightDiscoveryCapability>> SUSHI_WEIGHT_DISCOVERY = REGISTRY.register("sushi_weight_discovery", () -> AttachmentType.serializable(SushiWeightDiscoveryCapability::new).copyOnDeath().copyHandler((IAttachmentCopyHandler)new IAttachmentCopyHandler<SushiWeightDiscoveryCapability>(){

            @Nullable
            public SushiWeightDiscoveryCapability copy(SushiWeightDiscoveryCapability sushiWeightDiscoveryCapability, IAttachmentHolder iAttachmentHolder, HolderLookup.Provider provider) {
                return sushiWeightDiscoveryCapability;
            }
        }).build());
    }
}

