/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.compat.jei.categories;

import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.block.machinery.CuttingBoardBlock;
import com.buuz135.sushigocrafting.compat.jei.categories.SushiRecipeTypes;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.CuttingBoardRecipe;
import com.buuz135.sushigocrafting.util.ItemStackUtil;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CuttingBoardCategory
implements IRecipeCategory<CuttingBoardRecipe> {
    private final IGuiHelper guiHelper;

    public CuttingBoardCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public RecipeType<CuttingBoardRecipe> getRecipeType() {
        return SushiRecipeTypes.CUTTING_BOARD;
    }

    public Component getTitle() {
        return Component.translatable((String)((CuttingBoardBlock)((Object)SushiContent.Blocks.CUTTING_BOARD.get())).getDescriptionId());
    }

    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(80, 80);
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CuttingBoardRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 52).addIngredients(recipe.input);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 30, 0).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)FoodAPI.get().getIngredientFromName(recipe.ingredient).getItem()));
    }

    public void draw(CuttingBoardRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"textures/gui/jei.png"), 31, 22, 0, 0, 15, 22);
        float scale = 4.0f;
        guiGraphics.pose().scale(scale, scale, scale);
        ItemStackUtil.renderItemIntoGUI(guiGraphics.pose(), new ItemStack((ItemLike)SushiContent.Blocks.CUTTING_BOARD.get()), 2, 4);
        guiGraphics.pose().scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
    }
}

