/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.client.gui;

import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.client.gui.provider.SushiAssetTypes;
import com.buuz135.sushigocrafting.component.FoodTypeButtonComponent;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.text.WordUtils;

public class FoodTypeSelectionButtonAddon
extends BasicButtonAddon {
    private final Supplier<String> selected;

    public FoodTypeSelectionButtonAddon(FoodTypeButtonComponent buttonComponent, Supplier<String> selected) {
        super((ButtonComponent)buttonComponent);
        this.selected = selected;
        if (this.getButton().getType().getName().equalsIgnoreCase(selected.get())) {
            this.getButton().getComponent().get().setSlotPosition(this.getButton().getType().getSlotPosition());
            for (int i = 0; i < this.getButton().getComponent().get().getSlots(); ++i) {
                this.getButton().getComponent().get().setSlotToItemStackRender(i, this.getButton().getType().getSlotStackRender().apply(i));
            }
        }
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundLayer(guiGraphics, screen, provider, guiX, guiY, mouseX, mouseY, partialTicks);
        IAsset asset = provider.getAsset(SushiAssetTypes.ROLLER_TYPE_BG);
        if (asset != null) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)asset, (int)(guiX + this.getPosX() - 1), (int)(guiY + this.getPosY() - 1));
        }
        if ((asset = provider.getAsset(SushiAssetTypes.ROLLER_TYPE_BG_OVER)) != null && this.getButton().getType().getName().equalsIgnoreCase(this.selected.get())) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)asset, (int)(guiX + this.getPosX() - 1), (int)(guiY + this.getPosY() - 1));
        }
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundLayer(guiGraphics, screen, provider, guiX, guiY, mouseX, mouseY, partialTicks);
        Item item = (Item)FoodHelper.REGISTERED.get(this.getButton().getType().getName()).get(0).get();
        guiGraphics.renderItem(new ItemStack((ItemLike)item), this.getPosX(), this.getPosY());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AbstractContainerMenu abstractContainerMenu;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen && (abstractContainerMenu = ((AbstractContainerScreen)screen).getMenu()) instanceof ILocatable) {
            ILocatable locatable = (ILocatable)abstractContainerMenu;
            if (!this.isMouseOver(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(SoundEvents.WOOD_FALL, SoundSource.PLAYERS, 0.5f, 1.0f, Minecraft.getInstance().level.getRandom(), Minecraft.getInstance().player.blockPosition()));
            CompoundTag nbt = new CompoundTag();
            nbt.putString("Type", this.getButton().getType().getName());
            this.getButton().getComponent().get().setSlotPosition(this.getButton().getType().getSlotPosition());
            for (int i = 0; i < this.getButton().getComponent().get().getSlots(); ++i) {
                this.getButton().getComponent().get().setSlotToItemStackRender(i, this.getButton().getType().getSlotStackRender().apply(i));
            }
            Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), this.getButton().getId(), nbt));
            for (int i1 = 0; i1 < this.getButton().getComponent().get().getSlots(); ++i1) {
                this.getButton().getComponent().get().setSlotLimit(i1, i1 < this.getButton().getType().getFoodIngredients().size() ? 64 : 0);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.getPosX() && mouseX <= (double)(this.getPosX() + this.getXSize()) && mouseY >= (double)this.getPosY() && mouseY <= (double)(this.getPosY() + this.getYSize());
    }

    public List<Component> getTooltipLines() {
        return Collections.singletonList(Component.literal((String)WordUtils.capitalize((String)this.getButton().getType().getName())));
    }

    public FoodTypeButtonComponent getButton() {
        return (FoodTypeButtonComponent)super.getButton();
    }
}

