/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.client;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IIngredientEffect;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.effect.AddIngredientEffect;
import com.buuz135.sushigocrafting.api.impl.effect.ModifyIngredientEffect;
import com.buuz135.sushigocrafting.client.entity.ShrimpRenderer;
import com.buuz135.sushigocrafting.client.entity.TunaRenderer;
import com.buuz135.sushigocrafting.client.entity.model.ShrimpModel;
import com.buuz135.sushigocrafting.client.render.ContributorsBackRender;
import com.buuz135.sushigocrafting.client.tesr.CuttingBoardRenderer;
import com.buuz135.sushigocrafting.client.tesr.RollerRenderer;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.event.handler.EventManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class ClientProxy {
    public static BakedModel SALMON_BACK;
    public static BakedModel TUNA_BACK;

    public static void register() {
        EventManager.mod(EntityRenderersEvent.RegisterRenderers.class).process(event -> {
            event.registerEntityRenderer((EntityType)SushiContent.EntityTypes.TUNA.get(), TunaRenderer::new);
            event.registerEntityRenderer((EntityType)SushiContent.EntityTypes.SHRIMP.get(), ShrimpRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SushiContent.TileEntities.CUTTING_BOARD.get(), p_173571_ -> new CuttingBoardRenderer());
            event.registerBlockEntityRenderer((BlockEntityType)SushiContent.TileEntities.ROLLER.get(), p_173571_ -> new RollerRenderer());
        }).subscribe();
        EventManager.mod(EntityRenderersEvent.AddLayers.class).process(event -> {
            for (PlayerSkin.Model skin : event.getSkins()) {
                EntityRenderer renderer = event.getSkin(skin);
                if (!(renderer instanceof PlayerRenderer)) continue;
                PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
                playerRenderer.addLayer((RenderLayer)new ContributorsBackRender((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)playerRenderer));
            }
        }).subscribe();
        EventManager.mod(EntityRenderersEvent.RegisterLayerDefinitions.class).process(event -> event.registerLayerDefinition(new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"shrimp"), "main"), ShrimpModel::createBodyLayer)).subscribe();
        EventManager.mod(ModelEvent.RegisterAdditional.class).process(event -> {
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"block/salmon_back")));
            event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"block/tuna_back")));
        }).subscribe();
        EventManager.mod(ModelEvent.BakingCompleted.class).process(event -> {
            SALMON_BACK = (BakedModel)event.getModels().get(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"block/salmon_back")));
            TUNA_BACK = (BakedModel)event.getModels().get(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"block/tuna_back")));
        }).subscribe();
    }

    public void fmlClient(FMLClientSetupEvent fml) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SushiContent.Blocks.RICE_CROP.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SushiContent.Blocks.CUCUMBER_CROP.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SushiContent.Blocks.SOY_CROP.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SushiContent.Blocks.WASABI_CROP.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SushiContent.Blocks.AVOCADO_LEAVES_LOG.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SushiContent.Blocks.AVOCADO_LEAVES.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SushiContent.Blocks.AVOCADO_SAPLING.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SushiContent.Blocks.SESAME_CROP.get()), (RenderType)RenderType.cutout());
        EventManager.forge(ItemTooltipEvent.class).process(event -> {
            IFoodIngredient ingredient = FoodAPI.get().getIngredientFromItem(event.getItemStack().getItem());
            if (!ingredient.isEmpty() && ingredient.getEffect() != null) {
                event.getToolTip().add(Component.literal((String)""));
                if (Screen.hasShiftDown()) {
                    IIngredientEffect effect = ingredient.getEffect();
                    if (effect instanceof AddIngredientEffect) {
                        event.getToolTip().add(Component.literal((String)(String.valueOf(ChatFormatting.DARK_AQUA) + Component.translatable((String)"text.sushigocrafting.add_food_effect").getString() + ":")));
                        event.getToolTip().add(Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + " - " + String.valueOf(ChatFormatting.GOLD) + ((MobEffect)((AddIngredientEffect)effect).getEffect().value()).getDisplayName().getString() + String.valueOf(ChatFormatting.DARK_AQUA) + " (" + String.valueOf(ChatFormatting.WHITE) + ((AddIngredientEffect)effect).getDuration() / 20 + String.valueOf(ChatFormatting.YELLOW) + "s" + String.valueOf(ChatFormatting.DARK_AQUA) + ", " + String.valueOf(ChatFormatting.YELLOW) + "Level " + String.valueOf(ChatFormatting.WHITE) + (((AddIngredientEffect)effect).getLevel() + 1) + String.valueOf(ChatFormatting.DARK_AQUA) + ")")));
                    }
                    if (effect instanceof ModifyIngredientEffect) {
                        event.getToolTip().add(Component.literal((String)(String.valueOf(ChatFormatting.DARK_AQUA) + Component.translatable((String)"text.sushigocrafting.modify_food_effect").getString() + ":")));
                        if (((ModifyIngredientEffect)effect).getTimeModifier() != 1.0f) {
                            event.getToolTip().add(Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + " - " + String.valueOf(ChatFormatting.GOLD) + " " + Component.translatable((String)"text.sushigocrafting.multiply_time_by").getString() + " " + String.valueOf(ChatFormatting.WHITE) + ((ModifyIngredientEffect)effect).getTimeModifier())));
                        }
                        if (((ModifyIngredientEffect)effect).getLevelModifier() > 0) {
                            event.getToolTip().add(Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + " - " + String.valueOf(ChatFormatting.GOLD) + " " + Component.translatable((String)"text.sushigocrafting.increase_level_by").getString() + " " + String.valueOf(ChatFormatting.WHITE) + ((ModifyIngredientEffect)effect).getLevelModifier())));
                        }
                    }
                } else {
                    event.getToolTip().add(Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + Component.translatable((String)"text.sushigocrafting.hold").getString() + String.valueOf(ChatFormatting.GOLD) + " " + String.valueOf(ChatFormatting.ITALIC) + "<" + Component.translatable((String)"key.keyboard.left.shift").getString() + ">" + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.YELLOW) + Component.translatable((String)"text.sushigocrafting.sushi_effect").getString())));
                }
            }
        }).subscribe();
    }
}

