/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.block.machinery;

import com.buuz135.sushigocrafting.tile.machinery.FermentationBarrelTile;
import com.hrznstudio.titanium.block.RotatableBlock;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FermentationBarrelBlock
extends RotatableBlock<FermentationBarrelTile> {
    public static VoxelShape NORMAL = Stream.of(Block.box((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)2.0), Block.box((double)2.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)2.0, (double)14.5, (double)2.0, (double)14.0, (double)15.5, (double)14.0), Block.box((double)1.0, (double)1.0, (double)2.0, (double)2.0, (double)15.0, (double)14.0), Block.box((double)14.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)14.0), Block.box((double)4.0, (double)15.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0), Block.box((double)11.0, (double)15.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public FermentationBarrelBlock() {
        super("fermentation_barrel", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD), FermentationBarrelTile.class);
    }

    public Item asItem() {
        return Item.byBlock((Block)this);
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return FermentationBarrelTile::new;
    }

    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.NONE;
    }

    @Nonnull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return NORMAL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return NORMAL;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        this.getTile((BlockGetter)worldIn, pos).filter(riceCookerTile -> riceCookerTile.getBar().getProgress() > 0).ifPresent(riceCookerTile -> {
            double d0 = (double)pos.getX() + 0.5 - worldIn.random.nextDouble() / 2.0 + 0.25;
            double d1 = (double)pos.getY() + 1.01;
            double d2 = (double)pos.getZ() + 0.5 - worldIn.random.nextDouble() / 2.0 + 0.25;
            worldIn.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, d0, d1, d2, 0.0, 0.0, 0.0);
        });
    }
}

