/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util.neoforge;

import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.FakePlayer;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.util.FakePlayerMarker;

public class FakeMachinePlayerImpl
extends FakePlayer
implements FakePlayerMarker {
    private static final Map<FakeMachinePlayerKey, FakePlayer> FAKE_MACHINE_PLAYERS = new MapMaker().weakValues().makeMap();
    private final SimpleInventoryStorage inventory;

    private FakeMachinePlayerImpl(ServerLevel world, GameProfile profile, SimpleInventoryStorage inventory) {
        super(world, profile);
        this.inventory = inventory;
    }

    public static ServerPlayer create(ServerLevel world, GameProfile profile, SimpleInventoryStorage inventory) {
        FakeMachinePlayerKey key = new FakeMachinePlayerKey(world, profile);
        return (ServerPlayer)FAKE_MACHINE_PLAYERS.computeIfAbsent(key, k -> new FakeMachinePlayerImpl(k.world(), k.profile(), inventory));
    }

    public boolean addItem(ItemStack itemStack) {
        this.inventory.insert(itemStack, false);
        return true;
    }

    private record FakeMachinePlayerKey(ServerLevel world, GameProfile profile) {
    }
}

