/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Geometry {
    public static final float DEG_TO_RAD = (float)Math.PI / 180;

    public static Vec3i offsetToWorldPosition(Direction facing, Vec3i offset, Vec3i ownPos) {
        Vec3i rotated = Geometry.rotatePosition(offset, facing);
        return ownPos.offset(rotated);
    }

    public static Vec3 worldToOffsetPosition(Direction facing, Vec3 worldTarget, Vec3 ownPos) {
        Vec3 relativeWorld = worldTarget.subtract(ownPos);
        double relX = relativeWorld.x();
        double relY = relativeWorld.y();
        double relZ = relativeWorld.z();
        if (Objects.requireNonNull(facing) == Direction.NORTH) {
            return new Vec3(-relX, relY, -relZ);
        }
        if (facing == Direction.SOUTH) {
            return new Vec3(relX, relY, relZ);
        }
        if (facing == Direction.WEST) {
            return new Vec3(relZ, relY, -relX);
        }
        if (facing == Direction.EAST) {
            return new Vec3(-relZ, relY, relX);
        }
        if (facing == Direction.UP) {
            return new Vec3(relX, -relZ, relY);
        }
        if (facing == Direction.DOWN) {
            return new Vec3(relX, relZ, -relY);
        }
        throw new IllegalArgumentException();
    }

    public static Vec3i rotatePosition(Vec3i relativePos, Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new BlockPos(relativePos.getZ(), relativePos.getY(), relativePos.getX());
            case Direction.WEST -> new BlockPos(relativePos.getX(), relativePos.getY(), -relativePos.getZ());
            case Direction.SOUTH -> new BlockPos(-relativePos.getZ(), relativePos.getY(), -relativePos.getX());
            case Direction.EAST -> new BlockPos(-relativePos.getX(), relativePos.getY(), relativePos.getZ());
            case Direction.UP -> new BlockPos(-relativePos.getZ(), -relativePos.getX(), -relativePos.getY());
            case Direction.DOWN -> new BlockPos(relativePos.getZ(), relativePos.getX(), relativePos.getY());
        };
    }

    public static Vec3 rotatePosition(Vec3 relativePos, Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new Vec3(relativePos.z(), relativePos.y(), relativePos.x());
            case Direction.WEST -> new Vec3(relativePos.x(), relativePos.y(), -relativePos.z());
            case Direction.SOUTH -> new Vec3(-relativePos.z(), relativePos.y(), -relativePos.x());
            case Direction.EAST -> new Vec3(-relativePos.x(), relativePos.y(), relativePos.z());
            case Direction.UP -> new Vec3(-relativePos.z(), -relativePos.x(), -relativePos.y());
            case Direction.DOWN -> new Vec3(relativePos.z(), relativePos.x(), relativePos.y());
        };
    }

    public static Vec3i getForward(Direction facing) {
        return Geometry.rotatePosition((Vec3i)BlockDirection.FORWARD.pos, facing);
    }

    public static Vec3i getBackward(Direction facing) {
        return Geometry.rotatePosition((Vec3i)BlockDirection.BACKWARD.pos, facing);
    }

    public static Vec3i getRight(Direction facing) {
        return Geometry.rotatePosition((Vec3i)BlockDirection.RIGHT.pos, facing);
    }

    public static Vec3i getUp(Direction facing) {
        return Geometry.rotatePosition(new Vec3i(0, 1, 0), facing);
    }

    public static Vec3i getLeft(Direction facing) {
        return Geometry.rotatePosition((Vec3i)BlockDirection.LEFT.pos, facing);
    }

    public static Direction fromVector(Vec3i vector) {
        int x = vector.getX();
        int y = vector.getY();
        int z = vector.getZ();
        if (x == 0) {
            if (y == 0) {
                if (z > 0) {
                    return Direction.SOUTH;
                }
                if (z < 0) {
                    return Direction.NORTH;
                }
            } else if (z == 0) {
                if (y > 0) {
                    return Direction.UP;
                }
                return Direction.DOWN;
            }
        } else if (y == 0 && z == 0) {
            if (x > 0) {
                return Direction.EAST;
            }
            return Direction.WEST;
        }
        return null;
    }

    public static VoxelShape rotateVoxelShape(VoxelShape shape, Direction facing, AttachFace face) {
        double minX = shape.min(Direction.Axis.X);
        double maxX = shape.max(Direction.Axis.X);
        double minY = shape.min(Direction.Axis.Y);
        double maxY = shape.max(Direction.Axis.Y);
        double minZ = shape.min(Direction.Axis.Z);
        double maxZ = shape.max(Direction.Axis.Z);
        if (facing == Direction.NORTH) {
            if (face == AttachFace.FLOOR) {
                return shape;
            }
            if (face == AttachFace.WALL) {
                return Shapes.box((double)(1.0 - maxX), (double)(1.0 - maxZ), (double)(1.0 - maxY), (double)(1.0 - minX), (double)(1.0 - minZ), (double)(1.0 - minY));
            }
            if (face == AttachFace.CEILING) {
                return Shapes.box((double)minX, (double)(1.0 - maxY), (double)(1.0 - maxZ), (double)maxX, (double)(1.0 - minY), (double)(1.0 - minZ));
            }
        }
        if (facing == Direction.SOUTH) {
            if (face == AttachFace.FLOOR) {
                return Shapes.box((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ));
            }
            if (face == AttachFace.WALL) {
                return Shapes.box((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY);
            }
            if (face == AttachFace.CEILING) {
                return Shapes.box((double)(1.0 - maxX), (double)(1.0 - maxY), (double)minZ, (double)(1.0 - minX), (double)(1.0 - minY), (double)maxZ);
            }
        }
        if (facing == Direction.EAST) {
            if (face == AttachFace.FLOOR) {
                return Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
            }
            if (face == AttachFace.WALL) {
                return Shapes.box((double)minY, (double)(1.0 - maxZ), (double)(1.0 - maxX), (double)maxY, (double)(1.0 - minZ), (double)(1.0 - minX));
            }
            if (face == AttachFace.CEILING) {
                return Shapes.box((double)minZ, (double)(1.0 - maxY), (double)minX, (double)maxZ, (double)(1.0 - minY), (double)maxX);
            }
        }
        if (facing == Direction.WEST) {
            if (face == AttachFace.FLOOR) {
                return Shapes.box((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX));
            }
            if (face == AttachFace.WALL) {
                return Shapes.box((double)(1.0 - maxY), (double)(1.0 - maxZ), (double)minX, (double)(1.0 - minY), (double)(1.0 - minZ), (double)maxX);
            }
            if (face == AttachFace.CEILING) {
                return Shapes.box((double)(1.0 - maxZ), (double)(1.0 - maxY), (double)(1.0 - maxX), (double)(1.0 - minZ), (double)(1.0 - minY), (double)(1.0 - minX));
            }
        }
        if (facing == Direction.UP) {
            return Shapes.box((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY);
        }
        if (facing == Direction.DOWN) {
            return Shapes.box((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY);
        }
        return shape;
    }

    public static enum BlockDirection {
        FORWARD(new BlockPos(-1, 0, 0)),
        BACKWARD(new BlockPos(1, 0, 0)),
        LEFT(new BlockPos(0, 0, 1)),
        RIGHT(new BlockPos(0, 0, -1));

        public final BlockPos pos;

        private BlockDirection(BlockPos blockPos) {
            this.pos = blockPos;
        }
    }
}

