/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.util;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface ArmorEventHandler {
    public void onEquipped(Player var1, ItemStack var2);

    public void onUnequipped(Player var1, ItemStack var2);

    public static void processEvent(LivingEntity livingEntity, EquipmentSlot equipmentSlot, ItemStack previousStack, ItemStack currentStack) {
        if (livingEntity instanceof Player) {
            Player playerEntity = (Player)livingEntity;
            if (equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                ArmorEventHandler armorItem;
                Item item = previousStack.getItem();
                if (item instanceof ArmorEventHandler) {
                    armorItem = (ArmorEventHandler)item;
                    armorItem.onUnequipped(playerEntity, previousStack);
                }
                if ((item = currentStack.getItem()) instanceof ArmorEventHandler) {
                    armorItem = (ArmorEventHandler)item;
                    armorItem.onEquipped(playerEntity, currentStack);
                }
            }
        }
    }
}

