/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.client.ui.AcceleratorScreenHandler;
import rearth.oritech.client.ui.BasicMachineScreen;

public class AcceleratorScreen
extends BasicMachineScreen<AcceleratorScreenHandler> {
    public static final ResourceLocation PARTICLE_OVERLAY = Oritech.id("textures/gui/modular/particle_background_arrow.png");
    private LabelComponent titleLabel;
    private LabelComponent speedLabel;
    private LabelComponent statusLabel;
    private ItemComponent activeParticleRenderer;

    public AcceleratorScreen(AcceleratorScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    @Override
    public boolean showExtensionPanel() {
        return false;
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        ItemStack shownItem = ItemStack.EMPTY;
        if (((AcceleratorScreenHandler)this.menu).accelerator.lastEvent.activeParticle() != ItemStack.EMPTY) {
            shownItem = ((AcceleratorScreenHandler)this.menu).accelerator.lastEvent.activeParticle();
        }
        this.activeParticleRenderer = Components.item((ItemStack)shownItem);
        overlay.child((io.wispforest.owo.ui.core.Component)this.activeParticleRenderer.positioning(Positioning.absolute((int)7, (int)34)));
        io.wispforest.owo.ui.core.Component particleOverlay = Components.texture((ResourceLocation)PARTICLE_OVERLAY, (int)0, (int)0, (int)24, (int)30, (int)24, (int)30).sizing(Sizing.fixed((int)24), Sizing.fixed((int)30));
        particleOverlay.zIndex(-1);
        overlay.child(particleOverlay.positioning(Positioning.absolute((int)3, (int)27)));
        this.titleLabel = Components.label((Component)Component.literal((String)"Waiting...").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}));
        this.titleLabel.horizontalTextAlignment(HorizontalAlignment.CENTER).horizontalSizing(Sizing.fill()).verticalSizing(Sizing.fixed((int)10)).margins(Insets.of((int)1));
        this.speedLabel = Components.label((Component)Component.literal((String)"Speed: 0 blocks/s").withStyle(ChatFormatting.BLACK));
        this.speedLabel.margins(Insets.of((int)2));
        this.statusLabel = Components.label((Component)Component.literal((String)"Insert item to accelerate\nAnd some more details").withStyle(ChatFormatting.BLACK));
        this.statusLabel.horizontalTextAlignment(HorizontalAlignment.RIGHT).margins(Insets.of((int)2));
        FlowLayout labelContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)130), (Sizing)Sizing.fixed((int)100));
        labelContainer.child((io.wispforest.owo.ui.core.Component)this.titleLabel).child((io.wispforest.owo.ui.core.Component)this.speedLabel).child((io.wispforest.owo.ui.core.Component)this.statusLabel);
        labelContainer.horizontalAlignment(HorizontalAlignment.RIGHT);
        labelContainer.positioning(Positioning.relative((int)82, (int)30));
        overlay.child((io.wispforest.owo.ui.core.Component)labelContainer);
    }

    private void updateItemParticle() {
        ItemStack shownItem = ItemStack.EMPTY;
        if (((AcceleratorScreenHandler)this.menu).accelerator.lastEvent.lastEvent().equals((Object)AcceleratorControllerBlockEntity.ParticleEvent.ACCELERATING) && ((AcceleratorScreenHandler)this.menu).accelerator.lastEvent.activeParticle() != ItemStack.EMPTY) {
            shownItem = ((AcceleratorScreenHandler)this.menu).accelerator.lastEvent.activeParticle();
        }
        this.activeParticleRenderer.stack(shownItem);
    }

    @Override
    protected void containerTick() {
        AcceleratorControllerBlockEntity.LastEventPacket event = ((AcceleratorScreenHandler)this.menu).accelerator.lastEvent;
        this.titleLabel.horizontalTextAlignment(HorizontalAlignment.RIGHT);
        switch (event.lastEvent()) {
            case IDLE: {
                MutableComponent text = Component.translatable((String)"text.oritech.accelerator.ui.waiting.0");
                long time = ((AcceleratorScreenHandler)this.menu).blockEntity.getLevel().getGameTime();
                if (time / 20L % 3L == 1L) {
                    text = Component.translatable((String)"text.oritech.accelerator.ui.waiting.1");
                }
                if (time / 20L % 3L == 2L) {
                    text = Component.translatable((String)"text.oritech.accelerator.ui.waiting.2");
                }
                text = text.withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.BLACK});
                this.titleLabel.horizontalTextAlignment(HorizontalAlignment.LEFT).text((Component)text);
                this.speedLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.waiting").withStyle(ChatFormatting.BLACK));
                this.statusLabel.text((Component)Component.literal((String)" "));
                break;
            }
            case ERROR: {
                this.titleLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.error").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}));
                this.speedLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.nogate").withStyle(ChatFormatting.BLACK));
                this.statusLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.nogate.more").withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            case ACCELERATING: {
                float speed = event.lastEventSpeed();
                String gateDist = AcceleratorScreen.format(AcceleratorParticleLogic.getMaxGateDist(speed), 1);
                String curveDist = AcceleratorScreen.format(AcceleratorParticleLogic.getRequiredBendDist(speed), 1);
                this.titleLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.accelerating").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}));
                this.speedLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.accelerating.speed", (Object[])new Object[]{AcceleratorScreen.format(event.lastEventSpeed(), 0)}).withStyle(ChatFormatting.BLACK));
                this.statusLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.accelerating.stats", (Object[])new Object[]{gateDist, curveDist}).withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            case COLLIDED: {
                this.titleLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.collision").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}));
                this.speedLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.collision.stats", (Object[])new Object[]{AcceleratorScreen.format(event.lastEventSpeed(), 0)}).withStyle(ChatFormatting.BLACK));
                this.statusLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.collision.position", (Object[])new Object[]{event.lastEventPosition().toShortString()}).withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            case EXITED_FAST: {
                float speed = event.lastEventSpeed();
                String curveDist = AcceleratorScreen.format(AcceleratorParticleLogic.getRequiredBendDist(speed), 1);
                this.titleLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.exited").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}));
                this.speedLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.accelerating.speed", (Object[])new Object[]{AcceleratorScreen.format(event.lastEventSpeed(), 0)}).withStyle(ChatFormatting.BLACK));
                this.statusLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.exited.stats", (Object[])new Object[]{event.lastEventPosition().toShortString(), curveDist, AcceleratorScreen.format(event.minBendDist(), 1)}).withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            case EXITED_NO_GATE: {
                float speed = event.lastEventSpeed();
                String gateDist = AcceleratorScreen.format(AcceleratorParticleLogic.getMaxGateDist(speed), 1);
                this.titleLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.exited").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}));
                this.speedLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.accelerating.speed", (Object[])new Object[]{AcceleratorScreen.format(event.lastEventSpeed(), 0)}).withStyle(ChatFormatting.BLACK));
                this.statusLabel.text((Component)Component.translatable((String)"text.oritech.accelerator.ui.exited.nogate", (Object[])new Object[]{event.lastEventPosition().toShortString(), gateDist}).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        this.updateItemParticle();
        super.containerTick();
    }

    private static String format(float number, int decimal) {
        if (decimal <= 0) {
            return String.valueOf((int)number);
        }
        String format = "%." + decimal + "f";
        return String.format(format, Float.valueOf(number));
    }
}

