/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.blocks.augmenter.AugmentResearchStationBlock;
import rearth.oritech.block.blocks.processing.RefineryModuleBlock;
import rearth.oritech.block.blocks.storage.LargeStorageBlock;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.item.tools.harvesting.PromethiumPickaxeItem;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.MultiblockMachineController;

public class BlockOutlineRenderer {
    public static void render(ClientLevel world, Camera camera, PoseStack matrixStack, MultiBufferSource consumer) {
        if (world == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null || player.isShiftKeyDown()) {
            return;
        }
        if (client.hitResult == null || client.hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        BlockPos blockPos = ((BlockHitResult)client.hitResult).getBlockPos();
        if (Oritech.CONFIG.showMachinePreview()) {
            BlockOutlineRenderer.renderBlockPlacementPreviewOutline(world, camera, matrixStack, consumer, itemStack, player, blockPos);
            BlockOutlineRenderer.renderParticlePlacementHelper(world, camera, matrixStack, consumer, itemStack, player, blockPos);
        }
        BlockOutlineRenderer.renderPromethiumPickaxeOutline(world, camera, matrixStack, consumer, itemStack, player, blockPos);
    }

    private static void renderBlockPlacementPreviewOutline(ClientLevel world, Camera camera, PoseStack matrixStack, MultiBufferSource consumer, ItemStack itemStack, LocalPlayer player, BlockPos blockPos) {
        BlockState placementState;
        BlockEntity entity;
        EntityBlock entityProvider;
        Block block;
        block15: {
            block14: {
                boolean hasBlockItem;
                boolean bl = hasBlockItem = itemStack.getItem() instanceof BlockItem || itemStack.getItem().equals(ItemContent.UNSTABLE_CONTAINER);
                if (!hasBlockItem) {
                    return;
                }
                Block block2 = block = itemStack.getItem() instanceof BlockItem ? ((BlockItem)itemStack.getItem()).getBlock() : BlockContent.UNSTABLE_CONTAINER;
                if (!(block instanceof EntityBlock)) break block14;
                entityProvider = (EntityBlock)block;
                if (block.defaultBlockState().hasProperty((Property)MultiblockMachine.ASSEMBLED)) break block15;
            }
            return;
        }
        BlockPos machinePos = blockPos.offset(((BlockHitResult)player.minecraft.hitResult).getDirection().getNormal());
        if (itemStack.getItem().equals(ItemContent.UNSTABLE_CONTAINER)) {
            machinePos = blockPos;
        }
        if (!((entity = entityProvider.newBlockEntity(machinePos, placementState = block.getStateForPlacement(new BlockPlaceContext((Player)player, player.swingingArm, itemStack, (BlockHitResult)player.minecraft.hitResult)))) instanceof MultiblockMachineController)) {
            return;
        }
        MultiblockMachineController multiblockController = (MultiblockMachineController)entity;
        if (itemStack.getItem().equals(ItemContent.UNSTABLE_CONTAINER)) {
            boolean isValid;
            BlockState blockState = world.getBlockState(machinePos);
            boolean bl = isValid = blockState.is(TagContent.UNSTABLE_CONTAINER_SOURCES_LOW) || blockState.is(TagContent.UNSTABLE_CONTAINER_SOURCES_MEDIUM) || blockState.is(TagContent.UNSTABLE_CONTAINER_SOURCES_HIGH);
            if (!isValid) {
                return;
            }
        }
        List<Vec3i> coreOffsets = multiblockController.getCorePositions();
        Direction machineFacing = BlockOutlineRenderer.getFacingFromState(placementState);
        if (block instanceof LargeStorageBlock) {
            machineFacing = player.getDirection().getOpposite();
        } else if (block instanceof AugmentResearchStationBlock) {
            machineFacing = player.getNearestViewDirection();
        } else if (!(block instanceof MultiblockMachine) && !(block instanceof RefineryModuleBlock)) {
            machineFacing = machineFacing.getOpposite();
        }
        ArrayList<Vec3i> fullList = new ArrayList<Vec3i>(coreOffsets);
        fullList.add(Vec3i.ZERO);
        matrixStack.pushPose();
        Vec3 cameraPos = camera.getPosition();
        matrixStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        matrixStack.translate(0.005f, 0.005f, 0.005f);
        VoxelShape shape = Shapes.block();
        for (Vec3i coreOffset : fullList) {
            Vec3i fixedOffset = new Vec3i(coreOffset.getX(), coreOffset.getY(), coreOffset.getZ());
            Vec3i worldOffset = Geometry.offsetToWorldPosition(machineFacing, fixedOffset, (Vec3i)machinePos);
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)worldOffset.getX(), (double)worldOffset.getY(), (double)worldOffset.getZ(), (double)(worldOffset.getX() + 1), (double)(worldOffset.getY() + 1), (double)(worldOffset.getZ() + 1)));
        }
        LevelRenderer.renderShape((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (VoxelShape)shape, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        matrixStack.popPose();
    }

    private static Direction getFacingFromState(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            return (Direction)state.getValue((Property)BlockStateProperties.FACING);
        }
        if (state.hasProperty((Property)SmallStorageBlock.TARGET_DIR)) {
            return (Direction)state.getValue((Property)SmallStorageBlock.TARGET_DIR);
        }
        return Direction.NORTH;
    }

    private static void renderPromethiumPickaxeOutline(ClientLevel world, Camera camera, PoseStack matrixStack, MultiBufferSource consumer, ItemStack itemStack, LocalPlayer player, BlockPos blockPos) {
        if (!itemStack.is(ToolsContent.PROMETHIUM_PICKAXE)) {
            return;
        }
        List<BlockPos> offsetBlocks = PromethiumPickaxeItem.getOffsetBlocks((Level)world, (Player)player, blockPos);
        matrixStack.pushPose();
        Vec3 cameraPos = camera.getPosition();
        matrixStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        for (BlockPos offsetPos : offsetBlocks) {
            BlockState offsetState = world.getBlockState(offsetPos);
            VoxelShape renderShape = offsetState.getShape((BlockGetter)world, offsetPos);
            matrixStack.pushPose();
            matrixStack.translate((float)offsetPos.getX(), (float)offsetPos.getY(), (float)offsetPos.getZ());
            LevelRenderer.renderShape((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (VoxelShape)renderShape, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    private static void renderParticlePlacementHelper(ClientLevel world, Camera camera, PoseStack matrixStack, MultiBufferSource consumer, ItemStack itemStack, LocalPlayer player, BlockPos blockPos) {
        boolean isRing = itemStack.is(BlockContent.ACCELERATOR_RING.asItem());
        boolean isMotor = itemStack.is(BlockContent.ACCELERATOR_MOTOR.asItem());
        if (!isRing && !isMotor) {
            return;
        }
        assert (player.minecraft.hitResult != null);
        Direction facing = player.getDirection();
        Vec3 cameraPos = camera.getPosition();
        BlockHitResult blockHit = (BlockHitResult)player.minecraft.hitResult;
        Vec3 targetPos = Vec3.atLowerCornerOf((Vec3i)blockHit.getBlockPos().offset(blockHit.getDirection().getNormal()));
        if (isMotor) {
            facing = facing.getClockWise();
        }
        VoxelShape shape = Shapes.box((double)0.4375, (double)0.4375, (double)0.0, (double)0.5625, (double)0.5625, (double)1.0);
        VoxelShape halfShape = Shapes.box((double)0.25, (double)0.4375, (double)0.8, (double)0.375, (double)0.5625, (double)1.3f);
        VoxelShape halfShapeLeft = Shapes.box((double)0.5, (double)0.4375, (double)0.3, (double)0.625, (double)0.5625, (double)0.8f);
        matrixStack.pushPose();
        matrixStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        matrixStack.translate(targetPos.x, targetPos.y, targetPos.z);
        matrixStack.translate(0.005f, 0.005f, 0.005f);
        int rotationY = 0;
        Vec3 extraOffset = Vec3.ZERO;
        if (facing.equals((Object)Direction.WEST)) {
            rotationY = 90;
            extraOffset = new Vec3(0.0, 0.0, 1.0);
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            rotationY = 180;
            extraOffset = new Vec3(1.0, 0.0, 1.0);
        }
        if (facing.equals((Object)Direction.EAST)) {
            rotationY = 270;
            extraOffset = new Vec3(1.0, 0.0, 0.0);
        }
        matrixStack.translate(extraOffset.x, extraOffset.y, extraOffset.z);
        matrixStack.mulPose(Axis.YP.rotationDegrees((float)rotationY));
        LevelRenderer.renderShape((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (VoxelShape)shape, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isRing) {
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.YP.rotationDegrees(30.0f));
            LevelRenderer.renderShape((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (VoxelShape)halfShape, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.YP.rotationDegrees(-30.0f));
            LevelRenderer.renderShape((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (VoxelShape)halfShapeLeft, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

