/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.storage;

import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.SmallFluidTank;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ApiLookupCache;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.StackContext;

public class SmallTankEntity
extends NetworkedBlockEntity
implements FluidApi.BlockProvider,
ItemApi.BlockProvider,
ComparatorOutputProvider,
ScreenProvider,
ExtendedMenuProvider {
    private int lastComparatorOutput = 0;
    public final boolean isCreative;
    private ApiLookupCache<FluidApi.FluidStorage> downLookupCache;
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(3, this::setChanged, new InventorySlotAssignment(0, 2, 2, 1));
    @SyncField(value={SyncType.TICK, SyncType.INITIAL})
    public final SimpleFluidStorage fluidStorage = new SimpleFluidStorage((long)Oritech.CONFIG.portableTankCapacityBuckets() * FluidStackHooks.bucketAmount(), this::setChanged);

    public SmallTankEntity(BlockPos pos, BlockState state, boolean isCreative) {
        super(isCreative ? BlockEntitiesContent.CREATIVE_TANK_ENTITY : BlockEntitiesContent.SMALL_TANK_ENTITY, pos, state);
        this.isCreative = isCreative;
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.setChanged();
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (this.isCreative) {
            if (this.fluidStorage.getFluid() != Fluids.EMPTY) {
                this.fluidStorage.setAmount(this.fluidStorage.getCapacity() - FluidStackHooks.bucketAmount() * 8L);
            } else {
                this.fluidStorage.setAmount(0L);
            }
        }
        this.processInput();
        this.processOutput();
        if (this.fluidStorage.getAmount() > 0L) {
            this.outputToBelow();
        }
        this.updateComparators(world, pos, state);
    }

    private void outputToBelow() {
        FluidApi.FluidStorage tankCandidate;
        if (this.isCreative) {
            return;
        }
        if (this.downLookupCache == null) {
            this.downLookupCache = ApiLookupCache.create(this.worldPosition.below(), Direction.UP, Objects.requireNonNull(this.level), (world1, targetPos, targetState, targetEntity, direction) -> FluidApi.BLOCK.find(world1, targetPos, targetState, targetEntity, direction));
        }
        if (!((tankCandidate = this.downLookupCache.lookup()) instanceof SimpleFluidStorage)) {
            return;
        }
        SimpleFluidStorage belowTank = (SimpleFluidStorage)tankCandidate;
        SimpleFluidStorage ownTank = this.fluidStorage;
        SimpleFluidStorage.transfer(ownTank, belowTank, ownTank.getCapacity(), false);
    }

    private void updateComparators(Level world, BlockPos pos, BlockState state) {
        int previous = this.lastComparatorOutput;
        this.lastComparatorOutput = this.getComparatorOutput();
        if (previous != this.lastComparatorOutput) {
            world.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
    }

    private void processInput() {
        boolean canFill;
        ItemStack inStack = this.inventory.getItem(0);
        boolean bl = canFill = this.fluidStorage.getAmount() > 0L;
        if (!canFill || inStack.isEmpty() || inStack.getCount() > 1) {
            return;
        }
        StackContext stackRef = new StackContext(inStack, updated -> this.inventory.setItem(0, (ItemStack)updated));
        FluidApi.FluidStorage candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsInsertion()) {
            return;
        }
        long moved = FluidApi.transferFirst(this.fluidStorage, candidate, FluidStackHooks.bucketAmount() * 64L, false);
        if (moved == 0L) {
            ItemStack outStack = this.inventory.getItem(2);
            if (outStack.isEmpty()) {
                this.inventory.setItem(2, stackRef.getValue());
                this.inventory.setItem(0, ItemStack.EMPTY);
            } else if (outStack.getItem().equals(stackRef.getValue().getItem()) && outStack.getCount() < outStack.getMaxStackSize()) {
                outStack.grow(1);
                this.inventory.setItem(0, ItemStack.EMPTY);
            }
        }
    }

    private void processOutput() {
        boolean canFill;
        ItemStack inStack = this.inventory.getItem(1);
        boolean bl = canFill = this.fluidStorage.getAmount() < this.fluidStorage.getCapacity();
        if (!canFill || inStack.isEmpty() || inStack.getCount() > 1) {
            return;
        }
        StackContext stackRef = new StackContext(inStack, updated -> this.inventory.setItem(1, (ItemStack)updated));
        FluidApi.FluidStorage candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsExtraction()) {
            return;
        }
        long moved = FluidApi.transferFirst(candidate, this.fluidStorage, FluidStackHooks.bucketAmount() * 64L, false);
        if (moved == 0L) {
            ItemStack outStack = this.inventory.getItem(2);
            if (outStack.isEmpty()) {
                this.inventory.setItem(2, stackRef.getValue());
                this.inventory.setItem(1, ItemStack.EMPTY);
            } else if (outStack.getItem().equals(stackRef.getValue().getItem()) && outStack.getCount() < outStack.getMaxStackSize()) {
                outStack.grow(1);
                this.inventory.setItem(1, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public int getComparatorOutput() {
        if (this.fluidStorage.getFluid().equals(Fluids.EMPTY)) {
            return 0;
        }
        float fillPercentage = (float)this.fluidStorage.getAmount() / (float)this.fluidStorage.getCapacity();
        return (int)(1.0f + fillPercentage * 14.0f);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.isRemoved() && ((Boolean)this.getBlockState().getValue((Property)SmallFluidTank.LIT)).booleanValue() != this.isGlowingFluid()) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SmallFluidTank.LIT, (Comparable)Boolean.valueOf(this.isGlowingFluid())));
        }
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 50, 19), new ScreenProvider.GuiSlot(1, 50, 61), new ScreenProvider.GuiSlot(2, 130, 42, true));
    }

    @Override
    public ScreenProvider.BarConfiguration getFluidConfiguration() {
        return new ScreenProvider.BarConfiguration(70, 18, 21, 60);
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.TANK_SCREEN;
    }

    public boolean isGlowingFluid() {
        return this.fluidStorage.getAmount() > 0L && FluidStackHooks.getLuminosity((Fluid)this.fluidStorage.getFluid(), null, null) > 0;
    }

    @Override
    public boolean showEnergy() {
        return false;
    }

    @Override
    public ScreenProvider.ArrowConfiguration getIndicatorConfiguration() {
        return new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 95, 40, 29, 16, true);
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public FluidApi.SingleSlotStorage getFluidStorage(@Nullable Direction direction) {
        return this.fluidStorage;
    }
}

