/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.ScreenProvider;

public class FertilizerBlockEntity
extends ItemEnergyFrameInteractionBlockEntity
implements FluidApi.BlockProvider {
    public static final long FLUID_USAGE = (long)(Oritech.CONFIG.fertilizerConfig.liquidPerBlockUsage() * (float)FluidStackHooks.bucketAmount());
    @SyncField(value={SyncType.GUI_TICK})
    private final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(this, 4L * FluidStackHooks.bucketAmount(), this::setChanged){

        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            Fluid fluid = toInsert.getFluid();
            if (fluid.equals(FluidContent.STILL_MINERAL_SLURRY.get()) || fluid.equals(Fluids.WATER)) {
                return super.insert(toInsert, simulate);
            }
            return 0L;
        }
    };

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38));
    }

    public FertilizerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.FERTILIZER_BLOCK_ENTITY, pos, state);
    }

    private long getWaterUsagePerTick() {
        return (long)((float)FLUID_USAGE / this.getWorkTime());
    }

    private boolean hasEnoughWater() {
        return this.fluidStorage.getAmount() >= this.getWaterUsagePerTick();
    }

    @Override
    protected boolean canProgress() {
        return this.hasEnoughWater() && super.canProgress();
    }

    @Override
    protected boolean hasWorkAvailable(BlockPos toolPosition) {
        BonemealableBlock fertilizable;
        BlockPos targetPosition = toolPosition.below();
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPosition);
        if (this.canFertilizeFarmland(toolPosition)) {
            return true;
        }
        Block block = targetState.getBlock();
        return block instanceof BonemealableBlock && (fertilizable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)this.level, targetPosition, targetState);
    }

    private boolean canFertilizeFarmland(BlockPos toolPosition) {
        BlockPos targetPosition = toolPosition.below(2);
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPosition);
        if (targetState.getBlock() instanceof FarmBlock) {
            Integer moistureStatus = (Integer)targetState.getValue((Property)BlockStateProperties.MOISTURE);
            return moistureStatus != 7;
        }
        return false;
    }

    @Override
    public void finishBlockWork(BlockPos processed) {
        ItemStack inventoryStack = this.inventory.getItem(0);
        boolean fertilizerInInventory = !inventoryStack.isEmpty() && inventoryStack.is(TagContent.CONVENTIONAL_FERTILIZER);
        boolean mineralSlurried = this.fluidStorage.getFluid().equals(FluidContent.STILL_MINERAL_SLURRY.get());
        int fertilizerStrength = fertilizerInInventory ? 2 : 1;
        fertilizerStrength *= mineralSlurried ? 2 : 1;
        boolean fertilized = false;
        BlockPos targetPosition = processed.below();
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPosition);
        if (!this.hasWorkAvailable(processed)) {
            return;
        }
        Block block = targetState.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            int newAge = cropBlock.getAge(targetState) + fertilizerStrength;
            newAge = Math.min(newAge, cropBlock.getMaxAge());
            this.level.setBlock(targetPosition, cropBlock.getStateForAge(newAge), 2);
            fertilized = true;
        } else {
            block = targetState.getBlock();
            if (block instanceof BonemealableBlock) {
                BonemealableBlock fertilizable = (BonemealableBlock)block;
                fertilizable.performBonemeal((ServerLevel)this.level, this.level.random, targetPosition, targetState);
                if (fertilizerInInventory) {
                    fertilizable.performBonemeal((ServerLevel)this.level, this.level.random, targetPosition, targetState);
                    fertilized = true;
                }
            }
        }
        BlockPos farmlandPosition = processed.below(2);
        BlockState farmlandState = this.level.getBlockState(farmlandPosition);
        if (farmlandState.getBlock() instanceof FarmBlock && (Integer)farmlandState.getValue((Property)BlockStateProperties.MOISTURE) != 7) {
            this.level.setBlockAndUpdate(farmlandPosition, (BlockState)farmlandState.setValue((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7)));
        }
        if (fertilized) {
            if (fertilizerInInventory) {
                inventoryStack.shrink(1);
                this.inventory.setItem(0, inventoryStack);
            }
            super.finishBlockWork(processed);
            ParticleContent.FERTILIZER_EFFECT.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)targetPosition), (Object)(fertilizerStrength * 3 + 2));
            this.level.playSound(null, targetPosition, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public BlockState getMachineHead() {
        return BlockContent.BLOCK_FERTILIZER_HEAD.defaultBlockState();
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, -1, 0));
    }

    @Override
    protected void doProgress(boolean moving) {
        super.doProgress(moving);
        if (!moving && this.hasWorkAvailable(this.getCurrentTarget())) {
            this.fluidStorage.setAmount(this.fluidStorage.getAmount() - this.getWaterUsagePerTick());
            ParticleContent.WATERING_EFFECT.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)this.getCurrentTarget().below()), (Object)2);
        }
    }

    @Override
    public float getMoveTime() {
        return Oritech.CONFIG.fertilizerConfig.moveDuration();
    }

    @Override
    public float getWorkTime() {
        return Oritech.CONFIG.fertilizerConfig.workDuration();
    }

    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.fertilizerConfig.moveEnergyUsage();
    }

    @Override
    public int getOperationEnergyUsage() {
        return Oritech.CONFIG.fertilizerConfig.workEnergyUsage();
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.DESTROYER_SCREEN;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(Direction direction) {
        return this.fluidStorage;
    }
}

