/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.processing;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.base.block.UpgradableMachineBlock;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;

public class PulverizerBlock
extends UpgradableMachineBlock
implements EntityBlock {
    public PulverizerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    @NotNull
    public Class<? extends BlockEntity> getBlockEntityType() {
        return PulverizerBlockEntity.class;
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (!world.isClientSide && entity instanceof LivingEntity) {
            boolean isWorking;
            LivingEntity livingEntity = (LivingEntity)entity;
            Vec3 targetPos = pos.getCenter().add(0.0, 0.5, 0.0);
            double entityDist = entity.distanceToSqr(targetPos);
            if (entityDist > 0.7) {
                return;
            }
            boolean bl = isWorking = ((PulverizerBlockEntity)world.getBlockEntity((BlockPos)pos, BlockEntitiesContent.PULVERIZER_ENTITY).get()).progress > 0;
            if (isWorking) {
                livingEntity.hurt(new DamageSource((Holder)world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DamageTypes.CRAMMING).get()), 1.0f);
            }
        }
        super.stepOn(world, pos, state, entity);
    }
}

