/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;

public abstract class PassiveGeneratorBlockEntity
extends BlockEntity
implements EnergyApi.BlockProvider,
BlockEntityTicker<PassiveGeneratorBlockEntity> {
    protected final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(0L, 5000L, 200000L, () -> ((PassiveGeneratorBlockEntity)this).setChanged());

    public PassiveGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, PassiveGeneratorBlockEntity blockEntity) {
        int producedAmount;
        if (world.isClientSide) {
            return;
        }
        if (this.isProducing() && this.energyStorage.insertIgnoringLimit(producedAmount = this.getProductionRate(), false) > 0L) {
            this.energyStorage.update();
        }
        this.outputEnergy();
    }

    private void outputEnergy() {
        if (this.energyStorage.getAmount() <= 0L) {
            return;
        }
        for (Tuple<BlockPos, Direction> target : this.getOutputTargets(this.worldPosition, this.level)) {
            EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.level, (BlockPos)target.getA(), (Direction)target.getB());
            if (candidate == null) continue;
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    public abstract int getProductionRate();

    public abstract boolean isProducing();

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.energyStorage.setAmount(nbt.getLong("energy"));
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putLong("energy", this.energyStorage.getAmount());
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    protected abstract Set<Tuple<BlockPos, Direction>> getOutputTargets(BlockPos var1, Level var2);
}

