/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualElementCrafting;
import blusunrize.lib.manual.ManualElementEntity;
import blusunrize.lib.manual.ManualElementImage;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.utils.ItemStackHashStrategy;
import blusunrize.lib.manual.utils.ManualLogger;
import blusunrize.lib.manual.utils.ManualRecipeRef;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ManualInstance
implements ResourceManagerReloadListener,
ClientAdvancements.Listener {
    public ResourceLocation texture;
    private final Map<ResourceLocation, Function<JsonObject, SpecialManualElement>> specialElements = new HashMap<ResourceLocation, Function<JsonObject, SpecialManualElement>>();
    private final Tree<ResourceLocation, ManualEntry> contentTree;
    private final List<Pair<List<ResourceLocation>, ManualEntry>> autoloadedEntries = new ArrayList<Pair<List<ResourceLocation>, ManualEntry>>();
    private final List<List<ResourceLocation>> autoloadedSections = new ArrayList<List<ResourceLocation>>();
    public Map<ResourceLocation, ManualEntry> contentsByName = new HashMap<ResourceLocation, ManualEntry>();
    public final int pageWidth;
    public final int pageHeight;
    private int numFailedEntries = 0;
    private boolean initialized = false;
    private final Set<ResourceLocation> unlockedAdvancements = new HashSet<ResourceLocation>();
    private final Map<ItemStack, ManualLink> itemLinks = new Object2ObjectOpenCustomHashMap(ItemStackHashStrategy.INSTANCE);

    public ManualInstance(ResourceLocation texture, int pageWidth, int pageHeight, ResourceLocation name) {
        this.texture = texture;
        this.pageHeight = pageHeight;
        this.pageWidth = pageWidth;
        this.contentTree = new Tree(name);
        ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)this);
        this.registerSpecialElement(name.withPath("crafting"), s -> {
            ManualRecipeRef[][] stacksAndRecipes;
            if (GsonHelper.isArrayNode((JsonObject)s, (String)"recipes")) {
                JsonArray data = GsonHelper.getAsJsonArray((JsonObject)s, (String)"recipes");
                stacksAndRecipes = new ManualRecipeRef[data.size()][];
                for (int i = 0; i < data.size(); ++i) {
                    JsonElement el = data.get(i);
                    if (el.isJsonArray()) {
                        JsonArray inner = el.getAsJsonArray();
                        ManualRecipeRef[] innerSaR = new ManualRecipeRef[inner.size()];
                        for (int j = 0; j < inner.size(); ++j) {
                            innerSaR[j] = ManualUtils.getRecipeObjFromJson(this, inner.get(j));
                        }
                        stacksAndRecipes[i] = innerSaR;
                        continue;
                    }
                    stacksAndRecipes[i] = new ManualRecipeRef[]{ManualUtils.getRecipeObjFromJson(this, el)};
                }
            } else {
                stacksAndRecipes = new ManualRecipeRef[1][1];
                stacksAndRecipes[0][0] = ManualUtils.getRecipeObjFromJson(this, (JsonElement)s);
            }
            return new ManualElementCrafting(this, stacksAndRecipes);
        });
        this.registerSpecialElement(name.withPath("image"), s -> {
            JsonArray data = GsonHelper.getAsJsonArray((JsonObject)s, (String)"images");
            ManualElementImage.ManualImage[] images = new ManualElementImage.ManualImage[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                JsonObject img = data.get(i).getAsJsonObject();
                ResourceLocation loc = ManualUtils.getLocationForManual(GsonHelper.getAsString((JsonObject)img, (String)"location"), this);
                int uMin = GsonHelper.getAsInt((JsonObject)img, (String)"uMin");
                int vMin = GsonHelper.getAsInt((JsonObject)img, (String)"vMin");
                int uSize = GsonHelper.getAsInt((JsonObject)img, (String)"uSize");
                int vSize = GsonHelper.getAsInt((JsonObject)img, (String)"vSize");
                images[i] = new ManualElementImage.ManualImage(loc, uMin, uSize, vMin, vSize);
            }
            return new ManualElementImage(this, images);
        });
        this.registerSpecialElement(name.withPath("item_display"), s -> {
            NonNullList stacks;
            if (s.has("id")) {
                stacks = NonNullList.withSize((int)1, (Object)ManualUtils.getItemStackFromJson(this, s.get("id")));
            } else {
                JsonElement items = s.get("items");
                JsonArray arr = items.getAsJsonArray();
                stacks = NonNullList.withSize((int)arr.size(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < arr.size(); ++i) {
                    stacks.set(i, (Object)ManualUtils.getItemStackFromJson(this, arr.get(i)));
                }
            }
            return new ManualElementItem(this, (NonNullList<ItemStack>)stacks);
        });
        this.registerSpecialElement(name.withPath("table"), s -> {
            JsonArray arr = GsonHelper.getAsJsonArray((JsonObject)s, (String)"table");
            Component[][] table = new Component[arr.size()][];
            for (int i = 0; i < table.length; ++i) {
                JsonArray row = arr.get(i).getAsJsonArray();
                table[i] = new Component[row.size()];
                for (int j = 0; j < row.size(); ++j) {
                    table[i][j] = Component.nullToEmpty((String)row.get(j).getAsString());
                }
            }
            return new ManualElementTable(this, table, GsonHelper.getAsBoolean((JsonObject)s, (String)"horizontal_bars", (boolean)false));
        });
        this.registerSpecialElement(name.withPath("entity"), s -> {
            String sType = GsonHelper.getAsString((JsonObject)s, (String)"id");
            Optional type = EntityType.byString((String)sType);
            if (type.isEmpty()) {
                throw new IllegalArgumentException("Type " + sType + " is not a valid entity type!");
            }
            CompoundTag entityData = null;
            if (s.has("nbt")) {
                try {
                    JsonElement element = s.get("nbt");
                    entityData = element.isJsonObject() ? TagParser.parseTag((String)element.toString()) : TagParser.parseTag((String)GsonHelper.convertToString((JsonElement)element, (String)"nbt"));
                }
                catch (CommandSyntaxException e) {
                    throw new JsonSyntaxException("Invalid NBT Entry: " + String.valueOf((Object)e));
                }
            }
            return new ManualElementEntity(this, (EntityType)type.get(), entityData);
        });
    }

    public void registerSpecialElement(ResourceLocation resLoc, Function<JsonObject, SpecialManualElement> factory) {
        if (this.specialElements.containsKey(resLoc)) {
            throw new IllegalArgumentException("Tried adding manual element type " + String.valueOf(resLoc) + " twice!");
        }
        this.specialElements.put(resLoc, factory);
    }

    public Tree.InnerNode<ResourceLocation, ManualEntry> getRoot() {
        return this.contentTree.getRoot();
    }

    public Stream<Tree.AbstractNode<ResourceLocation, ManualEntry>> getAllEntriesAndCategories() {
        return this.contentTree.fullStream();
    }

    public Function<JsonObject, SpecialManualElement> getElementFactory(ResourceLocation loc) {
        Function<JsonObject, SpecialManualElement> ret = this.specialElements.get(loc);
        if (ret == null) {
            throw new IllegalArgumentException("No element type found for " + String.valueOf(loc));
        }
        return ret;
    }

    public abstract String getDefaultResourceDomain();

    public abstract String getManualName();

    public abstract String formatCategoryName(ResourceLocation var1);

    public abstract String formatEntryName(String var1);

    public abstract String formatEntrySubtext(String var1);

    public abstract String formatLink(ManualLink var1);

    public abstract String formatText(String var1);

    public abstract boolean showCategoryInList(String var1);

    public boolean showNodeInList(Tree.AbstractNode<ResourceLocation, ManualEntry> node) {
        if (!node.isLeaf()) {
            return node.getChildren().stream().anyMatch(this::showNodeInList);
        }
        Optional<ResourceLocation> advancement = node.getLeafData().getRequiredAdvancement();
        return advancement.map(this.unlockedAdvancements::contains).orElse(true);
    }

    public abstract int getTitleColour();

    public abstract int getSubTitleColour();

    public abstract int getTextColour();

    public abstract int getHighlightColour();

    public abstract int getPagenumberColour();

    public abstract int getGuiRescale();

    public abstract boolean improveReadability();

    public void openManual() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            this.unlockedAdvancements.clear();
            player.connection.getAdvancements().setListener((ClientAdvancements.Listener)this);
        }
    }

    public void closeManual() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.connection.getAdvancements().setListener(null);
        }
    }

    public void openEntry(ManualEntry entry) {
    }

    public void titleRenderPre() {
    }

    public void titleRenderPost() {
    }

    public void entryRenderPre() {
    }

    public void entryRenderPost() {
    }

    public ManualScreen getGui() {
        return this.getGui(true);
    }

    public ManualScreen getGui(boolean useLastActive) {
        if (useLastActive && ManualScreen.lastActiveManual != null && ManualScreen.lastActiveManual.getManual() == this) {
            return ManualScreen.lastActiveManual;
        }
        if (!this.initialized) {
            long start = System.currentTimeMillis();
            this.reload();
            ManualLogger.LOGGER.info("Manual reload took {} ms", (Object)(System.currentTimeMillis() - start));
            if (this.numFailedEntries > 0) {
                LocalPlayer player = Minecraft.getInstance().player;
                String error = this.numFailedEntries + " entries failed to load! Please report this as an issue with your log file!";
                if (player != null) {
                    player.sendSystemMessage((Component)Component.literal((String)error).setStyle(Style.EMPTY.applyFormat(ChatFormatting.RED)));
                } else {
                    ManualLogger.LOGGER.error(error);
                }
                return null;
            }
        }
        return new ManualScreen(this, this.texture, useLastActive);
    }

    public void addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ManualEntry entry) {
        int nextPrio = node.getChildren().size();
        this.addEntry(node, entry, nextPrio);
    }

    public void addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ManualEntry entry, int priority) {
        this.addEntry(node, entry, () -> priority);
    }

    public void addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ManualEntry entry, DoubleSupplier priority) {
        node.addNewLeaf(entry, priority);
        this.reset();
    }

    public void reset() {
        this.initialized = false;
        ManualScreen.lastActiveManual = null;
    }

    public ManualEntry addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ResourceLocation source) {
        int nextPrio = node.getChildren().size();
        return this.addEntry(node, source, nextPrio);
    }

    public ManualEntry addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ResourceLocation source, int priority) {
        return this.addEntry(node, source, () -> priority);
    }

    public ManualEntry addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ResourceLocation source, DoubleSupplier priority) {
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(this);
        builder.readFromFile(source);
        ManualEntry entry = builder.create();
        this.addEntry(node, entry, priority);
        return entry;
    }

    public DoubleSupplier atOffsetFrom(Tree.InnerNode<ResourceLocation, ManualEntry> node, String baseEntry, double offset) {
        return this.atOffsetFrom(node, ManualUtils.getLocationForManual(baseEntry, this), offset);
    }

    public DoubleSupplier atOffsetFrom(Tree.InnerNode<ResourceLocation, ManualEntry> node, ResourceLocation baseEntry, double offset) {
        return () -> {
            double baseWeight = this.findEntry(baseEntry, node).getWeight();
            return baseWeight + offset;
        };
    }

    @javax.annotation.Nullable
    public ManualEntry getEntry(ResourceLocation loc) {
        return this.contentsByName.get(loc);
    }

    public void indexRecipes() {
        this.itemLinks.clear();
        this.getAllEntries().forEach(entry -> {
            try {
                List<ManualEntry.SpecialElementData> specials = entry.getSpecialData();
                for (ManualEntry.SpecialElementData page : specials) {
                    SpecialManualElement p = page.getElement();
                    p.recalculateCraftingRecipes();
                    for (ItemStack s : p.getProvidedRecipes()) {
                        this.itemLinks.put(s.copy(), new ManualLink((ManualEntry)entry, page.getAnchor(), page.getOffset()));
                    }
                }
            }
            catch (Exception x) {
                ManualLogger.LOGGER.error("While calculating recipes for {}", (Object)entry.getLocation(), (Object)x);
                ++this.numFailedEntries;
            }
        });
    }

    public ManualLink getManualLink(ItemStack stack) {
        return this.itemLinks.get(stack);
    }

    public Stream<ManualEntry> getAllEntries() {
        return this.contentTree.leafStream();
    }

    public void onResourceManagerReload(@Nonnull ResourceManager resourceManager) {
        this.reset();
    }

    public void reload() {
        this.cleanupOldAutoloadedEntries();
        this.numFailedEntries = 0;
        this.getAllEntries().forEach(manualEntry -> {
            try {
                manualEntry.initBasic();
            }
            catch (Exception x) {
                ManualLogger.LOGGER.error("During basic init of entry {}", (Object)manualEntry.getLocation(), (Object)x);
                ++this.numFailedEntries;
            }
        });
        this.loadAutoEntries();
        if (this.numFailedEntries == 0) {
            this.contentTree.sortAll();
            this.contentsByName.clear();
            this.contentTree.leafStream().forEach(e -> this.contentsByName.put(e.getLocation(), (ManualEntry)e));
            this.indexRecipes();
            if (this.numFailedEntries == 0) {
                this.initialized = true;
            }
        }
    }

    private void cleanupOldAutoloadedEntries() {
        for (Pair<List<ResourceLocation>, ManualEntry> pair : this.autoloadedEntries) {
            this.getOrCreatePath((List)pair.getFirst(), p -> {}, 0.0).removeLeaf((ManualEntry)pair.getSecond());
        }
        for (List list : this.autoloadedSections) {
            List<ResourceLocation> parent = list.subList(0, list.size() - 1);
            this.getOrCreatePath(parent, p -> {
                throw new RuntimeException(p.toString() + " does not exist, but " + String.valueOf(list.get(parent.size())) + " should exist?");
            }, 0.0).removeSubnode((ResourceLocation)list.get(parent.size()));
        }
        this.autoloadedEntries.clear();
        this.autoloadedSections.clear();
    }

    private void loadAutoEntries() {
        ResourceLocation autoLoc = ManualUtils.getLocationForManual("manual/autoload.json", this);
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        resourceManager.listPacks().map(p -> p.getResource(PackType.CLIENT_RESOURCES, autoLoc)).filter(Objects::nonNull).map(r -> {
            Pair pair;
            block9: {
                InputStream stream = (InputStream)r.get();
                try {
                    JsonObject autoloadJson = GsonHelper.parse((Reader)new InputStreamReader(stream));
                    double priority = 0.0;
                    JsonElement priorityElement = autoloadJson.remove("autoload_priority");
                    if (priorityElement != null) {
                        priority = priorityElement.getAsDouble();
                    }
                    pair = Pair.of((Object)priority, (Object)autoloadJson);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException x) {
                        throw new RuntimeException(x);
                    }
                }
                stream.close();
            }
            return pair;
        }).sorted(Comparator.comparingDouble(Pair::getFirst).reversed()).forEach(p -> this.autoloadEntriesFromJson((JsonObject)p.getSecond(), new ArrayList<ResourceLocation>()));
    }

    private void autoloadEntriesFromJson(JsonObject obj, List<ResourceLocation> backtrace) {
        String entryListKey = "entry_list";
        String weightKey = "category_weight";
        double catWeight = obj.has("category_weight") ? obj.remove("category_weight").getAsDouble() : 0.0;
        Tree.InnerNode<ResourceLocation, ManualEntry> node = this.getOrCreatePath(backtrace, path -> {
            boolean parentIsAutoloaded = false;
            for (int i = 1; i <= path.size(); ++i) {
                if (!this.autoloadedSections.contains(path.subList(0, i))) continue;
                parentIsAutoloaded = true;
                break;
            }
            if (!parentIsAutoloaded) {
                this.autoloadedSections.add((List<ResourceLocation>)path);
            }
        }, catWeight);
        if (obj.has("entry_list")) {
            this.loadEntriesInArray(obj.remove("entry_list").getAsJsonArray(), backtrace, node);
        }
        for (Map.Entry otherEntry : obj.entrySet()) {
            Preconditions.checkState((boolean)((JsonElement)otherEntry.getValue()).isJsonObject(), (String)"At backtrace %s, key %s", backtrace, otherEntry.getKey());
            backtrace.add(ManualUtils.getLocationForManual((String)otherEntry.getKey(), this));
            this.autoloadEntriesFromJson(((JsonElement)otherEntry.getValue()).getAsJsonObject(), new ArrayList<ResourceLocation>(backtrace));
            backtrace.remove(backtrace.size() - 1);
        }
    }

    private void loadEntriesInArray(JsonArray entriesOnLevel, List<ResourceLocation> backtrace, Tree.InnerNode<ResourceLocation, ManualEntry> mainNode) {
        for (JsonElement e : entriesOnLevel) {
            double weight;
            String source;
            if (e.isJsonObject()) {
                source = e.getAsJsonObject().get("source").getAsString();
                weight = e.getAsJsonObject().get("weight").getAsDouble();
            } else {
                source = e.getAsString();
                weight = mainNode.getChildren().size();
            }
            try {
                ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(this);
                builder.readFromFile(ManualUtils.getLocationForManual(source, this));
                ManualEntry entry = builder.create();
                mainNode.addNewLeaf(entry, () -> weight);
                this.autoloadedEntries.add((Pair<List<ResourceLocation>, ManualEntry>)Pair.of(backtrace, (Object)entry));
                entry.initBasic();
            }
            catch (Exception x) {
                ManualLogger.LOGGER.error("During basic init of auto entry {}", (Object)source, (Object)x);
                ++this.numFailedEntries;
            }
        }
    }

    private Tree.InnerNode<ResourceLocation, ManualEntry> getOrCreatePath(List<ResourceLocation> path, Consumer<List<ResourceLocation>> onCreated, double newCatWeight) {
        Tree.InnerNode currentNode = this.getRoot();
        ArrayList<ResourceLocation> currentPath = new ArrayList<ResourceLocation>();
        for (ResourceLocation inner : path) {
            currentPath.add(inner);
            Tree.InnerNode lastNode = currentNode;
            currentNode = currentNode.getSubnode((ResourceLocation)inner).orElseGet(() -> {
                onCreated.accept(new ArrayList(currentPath));
                return lastNode.getOrCreateSubnode(inner, () -> newCatWeight);
            });
            Preconditions.checkNotNull((Object)currentNode);
        }
        return currentNode;
    }

    public Tree.Leaf<ResourceLocation, ManualEntry> findEntry(ResourceLocation name, Tree.InnerNode<ResourceLocation, ManualEntry> parent) {
        return parent.leafStream().filter(entry -> ((ManualEntry)entry.getLeafData()).getLocation().equals((Object)name)).findAny().orElseThrow(() -> new NoSuchElementException("Did not find a child with name " + String.valueOf(name)));
    }

    public abstract Font fontRenderer();

    public void onUpdateAdvancementProgress(AdvancementNode advancementNode, AdvancementProgress advancementProgress) {
        if (advancementProgress.isDone()) {
            this.unlockedAdvancements.add(advancementNode.holder().id());
        }
    }

    public void onAddAdvancementRoot(AdvancementNode advancementNode) {
    }

    public void onRemoveAdvancementRoot(AdvancementNode advancementNode) {
    }

    public void onAddAdvancementTask(AdvancementNode advancementNode) {
    }

    public void onRemoveAdvancementTask(AdvancementNode advancementNode) {
    }

    public void onAdvancementsCleared() {
    }

    public void onSelectedTabChanged(@Nullable AdvancementHolder advancementHolder) {
    }

    public static class ManualLink {
        @Nonnull
        private final ManualEntry key;
        private final String anchor;
        private final int offset;

        public ManualLink(@Nonnull ManualEntry key, String anchor, int offset) {
            this.key = key;
            this.anchor = anchor;
            this.offset = offset;
        }

        @Nonnull
        public ManualEntry getKey() {
            return this.key;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public int getOffset() {
            return this.offset;
        }

        public void changePage(ManualScreen manualScreen, boolean addCurrentToStack) {
            if (addCurrentToStack) {
                manualScreen.previousSelectedEntry.push(new ManualLink(manualScreen.getCurrentPage(), "start", manualScreen.page));
            }
            manualScreen.setCurrentNode(this.key.getTreeNode());
            manualScreen.page = this.getPage();
            manualScreen.fullInit();
        }

        public int getPage() {
            return this.getKey().getPageForAnchor(this.getAnchor()) + this.getOffset();
        }
    }
}

