/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.orientation;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class RotationUtil {
    public static final List<RotationBlacklistEntry> blacklist = new ArrayList<RotationBlacklistEntry>();

    public static boolean rotateBlock(Level world, BlockPos pos, boolean inverse) {
        return RotationUtil.rotateBlock(world, pos, inverse ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
    }

    public static boolean rotateBlock(Level world, BlockPos pos, Rotation rotation) {
        for (RotationBlacklistEntry e : blacklist) {
            if (e.blockRotation(world, pos)) continue;
            return false;
        }
        BlockState state = world.getBlockState(pos);
        BlockState newState = state.rotate((LevelAccessor)world, pos, rotation);
        if (newState != state) {
            BlockState otherState;
            BlockPos otherPos;
            world.setBlockAndUpdate(pos, newState);
            for (Direction d : DirectionUtils.VALUES) {
                otherPos = pos.relative(d);
                otherState = world.getBlockState(otherPos);
                BlockState nextState = newState.updateShape(d, otherState, (LevelAccessor)world, pos, otherPos);
                if (nextState == newState) continue;
                if (!nextState.isAir()) {
                    world.setBlockAndUpdate(pos, nextState);
                    newState = nextState;
                    continue;
                }
                world.setBlockAndUpdate(pos, state);
                return false;
            }
            for (Direction d : DirectionUtils.VALUES) {
                otherPos = pos.relative(d);
                otherState = world.getBlockState(otherPos);
                BlockState nextOther = otherState.updateShape(d.getOpposite(), newState, (LevelAccessor)world, otherPos, pos);
                if (nextOther == otherState) continue;
                world.setBlockAndUpdate(otherPos, nextOther);
            }
            return true;
        }
        return false;
    }

    public static boolean rotateEntity(Entity entity, Player player) {
        if (entity instanceof ArmorStand) {
            entity.setYRot((float)((double)entity.getYRot() + 22.5) % 360.0f);
        }
        return false;
    }

    static {
        blacklist.add((w, pos) -> {
            BlockState state = w.getBlockState(pos);
            return state.getBlock() != Blocks.CHEST || state.getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE;
        });
    }

    public static interface RotationBlacklistEntry {
        public boolean blockRotation(Level var1, BlockPos var2);
    }
}

