/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.cloche;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class ClocheRecipeCategory
extends IERecipeCategory<ClocheRecipe> {
    private final IDrawableStatic tankOverlay;
    private final IDrawableStatic chanceSlot;
    private final IDrawableAnimated arrow;

    public ClocheRecipeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.CLOCHE, "block.immersiveengineering.cloche");
        ResourceLocation background = IEApi.ieLoc("textures/gui/cloche.png");
        this.setBackground(helper.createDrawable(background, 0, 0, 176, 77));
        this.setIcon(new ItemStack(IEBlocks.MetalDevices.CLOCHE));
        this.tankOverlay = helper.createDrawable(background, 176, 30, 20, 51);
        this.chanceSlot = helper.drawableBuilder(JEIHelper.JEI_GUI, 0, 59, 18, 18).setTextureSize(128, 128).build();
        this.arrow = helper.drawableBuilder(background, 181, 1, 13, 13).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, ClocheRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 34).addItemStacks(Arrays.asList(recipe.seed.getItems()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 62, 54).addItemStacks(Arrays.asList(recipe.soil.getItems()));
        for (int i = 0; i < recipe.outputs.size(); ++i) {
            StackWithChance out = recipe.outputs.get(i);
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 116 + i % 2 * 18, 34 + i / 2 * 18).addItemStack(out.stack().get());
            if (!(out.chance() < 1.0f)) continue;
            slot.setBackground((IDrawable)this.chanceSlot, -1, -1).addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"desc.immersiveengineering.info.chance").append(" " + Utils.formatDouble(out.chance() * 100.0f, "0.##") + "%").withStyle(ChatFormatting.GOLD)));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).setFluidRenderer(4000L, false, 20, 51).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.requiredFluid.getStacks()))).addRichTooltipCallback(JEIHelper.fluidTooltipCallback);
        ArrayList<ItemStack> fertilizers = new ArrayList<ItemStack>(Collections.singleton(ItemStack.EMPTY));
        for (RecipeHolder<ClocheFertilizer> fertilizerList : ClocheFertilizer.RECIPES.getRecipes((Level)Minecraft.getInstance().level)) {
            fertilizers.addAll(Arrays.stream(((ClocheFertilizer)fertilizerList.value()).input.getItems()).toList());
        }
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 8, 59).addItemStacks(fertilizers);
    }

    @Override
    public void draw(ClocheRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 101, 35);
    }
}

