/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.generic.owners;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AutoWorkbenchLogic;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackEnvironment;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerCallable;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.IndexArgument;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.impl.MBEnergyCallbacks;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class AutoWorkbenchCallbacks
extends Callback<AutoWorkbenchLogic.State> {
    public AutoWorkbenchCallbacks() {
        this.addAdditional(MBEnergyCallbacks.INSTANCE, AutoWorkbenchLogic.State::getEnergy);
    }

    @ComputerCallable
    public boolean isRunning(CallbackEnvironment<AutoWorkbenchLogic.State> env) {
        return env.object().active;
    }

    @ComputerCallable
    public void selectRecipe(CallbackEnvironment<AutoWorkbenchLogic.State> env, @IndexArgument int selected) {
        List<RecipeHolder<BlueprintCraftingRecipe>> availableRecipes = AutoWorkbenchLogic.getAvailableRecipes(env.level(), env.object());
        if (selected < 0 || selected >= availableRecipes.size()) {
            throw new RuntimeException("Only " + availableRecipes.size() + " recipes are available");
        }
        env.object().selectedRecipe = selected;
    }

    @ComputerCallable
    public void unselectRecipe(CallbackEnvironment<AutoWorkbenchLogic.State> env) {
        env.object().selectedRecipe = -1;
    }

    @ComputerCallable
    public ItemStack[] getAvailableRecipes(CallbackEnvironment<AutoWorkbenchLogic.State> env) {
        List<RecipeHolder<BlueprintCraftingRecipe>> availableRecipes = AutoWorkbenchLogic.getAvailableRecipes(env.level(), env.object());
        ItemStack[] outputs = new ItemStack[availableRecipes.size()];
        for (int i = 0; i < availableRecipes.size(); ++i) {
            outputs[i] = ((BlueprintCraftingRecipe)availableRecipes.get((int)i).value()).output.get();
        }
        return outputs;
    }

    @ComputerCallable
    public int getSelectedRecipe(CallbackEnvironment<AutoWorkbenchLogic.State> env) {
        return env.object().selectedRecipe + 1;
    }
}

