/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.common.crafting.PotionHelper;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.util.compat.IECompatModules;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import java.util.EnumMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.DataComponentFluidIngredient;

public class CreateCompatModule
extends IECompatModules.StandardIECompatModule {
    @Override
    public void init() {
        Fluid potionFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"potion"));
        DataComponentType bottleComponentType = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"potion_fluid_bottle_type"));
        if (bottleComponentType == null) {
            return;
        }
        EnumMap typeConversion = new EnumMap(PotionFluid.PotionBottleType.class);
        for (PotionFluid.PotionBottleType myBottle : PotionFluid.PotionBottleType.values()) {
            bottleComponentType.codec().terminal().decode((DynamicOps)JavaOps.INSTANCE, (Object)myBottle.getSerializedName()).result().ifPresent(t -> typeConversion.put(myBottle, t));
        }
        PotionHelper.CREATE_POTION_BUILDER = (potionHolder, potionBottleType) -> {
            DataComponentPredicate.Builder pred = DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potionHolder));
            if (potionBottleType != null) {
                pred.expect(bottleComponentType, (Object)((Enum)typeConversion.get(potionBottleType)));
            }
            return DataComponentFluidIngredient.of((boolean)false, (DataComponentPredicate)pred.build(), (Fluid[])new Fluid[]{potionFluid});
        };
    }
}

