/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageRedstoneLevel;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageRequestRedstoneUpdate(BlockPos pos) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageRequestRedstoneUpdate> ID = IMessage.createType("request_rs_update");
    public static final StreamCodec<ByteBuf, MessageRequestRedstoneUpdate> CODEC = BlockPos.STREAM_CODEC.map(MessageRequestRedstoneUpdate::new, MessageRequestRedstoneUpdate::pos);

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            PacketDistributor.sendToPlayer((ServerPlayer)IMessage.serverPlayer(context), (CustomPacketPayload)new MessageRedstoneLevel(MessageRequestRedstoneUpdate.buildData(level, this.pos)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    private static VoltmeterItem.RemoteRedstoneData buildData(Level level, BlockPos pos) {
        IEBlockInterfaces.IRedstoneOutput iRedstoneOutput;
        Pair<DyeColor, Byte>[] override;
        BlockState blockState = level.getBlockState(pos);
        if (!blockState.isSignalSource()) {
            return new VoltmeterItem.RemoteRedstoneData(pos, level.getGameTime(), false, 0);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IEBlockInterfaces.IRedstoneOutput && (override = (iRedstoneOutput = (IEBlockInterfaces.IRedstoneOutput)blockEntity).overrideVoltmeterRead()) != null) {
            return new VoltmeterItem.RemoteRedstoneData(pos, level.getGameTime(), true, override);
        }
        return new VoltmeterItem.RemoteRedstoneData(pos, level.getGameTime(), true, MessageRequestRedstoneUpdate.redstoneLevel(level, pos));
    }

    public static byte redstoneLevel(Level level, BlockPos pos) {
        byte redstoneLevel;
        BlockState blockState = level.getBlockState(pos);
        if (blockState.isSignalSource()) {
            redstoneLevel = blockState.getOptionalValue((Property)RedStoneWireBlock.POWER).orElse(0).byteValue();
            for (Direction facing : Direction.values()) {
                redstoneLevel = (byte)Math.max(redstoneLevel, blockState.getSignal((BlockGetter)level, pos, facing));
            }
        } else {
            redstoneLevel = (byte)level.getDirectSignalTo(pos);
        }
        return redstoneLevel;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

