/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.sound.NoisyToolSoundHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageNoisyToolAttack(int noisyToolHolderID) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageNoisyToolAttack> ID = IMessage.createType("noisy_tool_attack");
    public static final StreamCodec<ByteBuf, MessageNoisyToolAttack> CODEC = ByteBufCodecs.INT.map(MessageNoisyToolAttack::new, MessageNoisyToolAttack::noisyToolHolderID);

    public MessageNoisyToolAttack(LivingEntity holder) {
        this(holder.getId());
    }

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (entity = world.getEntity(this.noisyToolHolderID)) instanceof LivingEntity) {
                LivingEntity noisyToolHolder = (LivingEntity)entity;
                NoisyToolSoundHandler.handleAttack(noisyToolHolder);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

