/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;

public class SurveyToolsItem
extends IEBaseItem {
    private static final List<BiPredicate<Level, BlockPos>> CAN_USE_ON = new ArrayList<BiPredicate<Level, BlockPos>>();
    private static final String DATA_KEY = "veinData";

    public SurveyToolsItem() {
        super(new Item.Properties().stacksTo(1).durability(300));
        CAN_USE_ON.add((world, pos) -> world.getBlockState(pos).is(IETags.surveyToolTargets));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 50;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!CAN_USE_ON.stream().anyMatch(predicate -> predicate.test(world, pos))) {
            player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.survey.wrong_block"), true);
            return InteractionResult.FAIL;
        }
        player.startUsingItem(context.getHand());
        return InteractionResult.SUCCESS;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entityLiving) {
        MutableComponent response;
        if (!(entityLiving instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entityLiving;
        BlockHitResult rtr = SurveyToolsItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = rtr.getBlockPos();
        MineralVein vein = ExcavatorHandler.getRandomMineral(world, pos);
        if (vein == null || vein.getMineral(world) == null) {
            player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.survey.no_vein"), true);
            return stack;
        }
        List<HintedPosition> oldHints = SurveyToolsItem.getVeinData(stack, (ResourceKey<Level>)world.dimension(), vein.getPos());
        int dataCount = oldHints.size();
        boolean tooClose = oldHints.stream().anyMatch(hint -> {
            int dZ;
            int dX = hint.x - pos.getX();
            return dX * dX + (dZ = hint.z - pos.getZ()) * dZ < 16;
        });
        if (tooClose) {
            player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.survey.too_close"), true);
            return stack;
        }
        Vec2 vecToCenter = new Vec2((float)(vein.getPos().x() - pos.getX()), (float)(vein.getPos().z() - pos.getZ()));
        if (vecToCenter.x == 0.0f && vecToCenter.y == 0.0f) {
            response = Component.translatable((String)"chat.immersiveengineering.info.survey.hint.center", (Object[])new Object[]{Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName()))});
        } else {
            double angle = Math.toDegrees(Math.atan2(vecToCenter.y, vecToCenter.x));
            int segment = (int)((angle + 270.0) % 360.0 / 45.0);
            response = switch (dataCount) {
                case 0 -> Component.translatable((String)"chat.immersiveengineering.info.survey.hint.1", (Object[])new Object[]{Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName()))});
                case 1 -> Component.translatable((String)"chat.immersiveengineering.info.survey.hint.2", (Object[])new Object[]{Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName())), Component.translatable((String)("chat.immersiveengineering.info.survey.direction." + segment))});
                default -> Component.translatable((String)"chat.immersiveengineering.info.survey.hint.3", (Object[])new Object[]{Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName())), Math.round(Math.sqrt(vecToCenter.x * vecToCenter.x + vecToCenter.y * vecToCenter.y)), Component.translatable((String)("chat.immersiveengineering.info.survey.direction." + segment))});
            };
        }
        player.displayClientMessage((Component)response, false);
        SurveyToolsItem.addHintedPosition(stack, (ResourceKey<Level>)world.dimension(), vein.getPos(), new HintedPosition(pos.getX(), pos.getZ(), (Component)response));
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOOK_PAGE_TURN, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.4f);
        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        return stack;
    }

    public static List<HintedPosition> getVeinData(ItemStack surveyTools, ResourceKey<Level> dimension, ColumnPos veinPos) {
        List allVeins = (List)surveyTools.getOrDefault(IEDataComponents.SURVERYTOOL_DATA, List.of());
        for (VeinEntry vein : allVeins) {
            if (vein.x != veinPos.x() || vein.z != veinPos.z() || !vein.level.equals(dimension)) continue;
            return vein.hinted;
        }
        return List.of();
    }

    public static void addHintedPosition(ItemStack surveyTools, ResourceKey<Level> dimension, ColumnPos veinPos, HintedPosition toAdd) {
        ArrayList<VeinEntry> newVeins = new ArrayList<VeinEntry>((Collection)surveyTools.getOrDefault(IEDataComponents.SURVERYTOOL_DATA, List.of()));
        boolean found = false;
        for (int i = 0; i < newVeins.size(); ++i) {
            VeinEntry vein = (VeinEntry)newVeins.get(i);
            if (vein.x != veinPos.x() || vein.z != veinPos.z() || !vein.level.equals(dimension)) continue;
            found = true;
            ArrayList<HintedPosition> newHints = new ArrayList<HintedPosition>(vein.hinted);
            newHints.add(toAdd);
            newVeins.set(i, new VeinEntry(vein.x, vein.z, vein.level, newHints));
            break;
        }
        if (!found) {
            newVeins.add(new VeinEntry(veinPos.x(), veinPos.z(), dimension, List.of(toAdd)));
        }
        surveyTools.set(IEDataComponents.SURVERYTOOL_DATA, newVeins);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return false;
    }

    private record HintedPosition(int x, int z, Component hintText) {
        public static final DualCodec<RegistryFriendlyByteBuf, HintedPosition> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.INT.fieldOf("x"), HintedPosition::x, (DualMapCodec)DualCodecs.INT.fieldOf("z"), HintedPosition::z, (DualMapCodec)DualCodecs.CHAT_COMPONENT.fieldOf("hintText"), HintedPosition::hintText, HintedPosition::new);
    }

    public record VeinEntry(int x, int z, ResourceKey<Level> level, List<HintedPosition> hinted) {
        public static final DualCodec<RegistryFriendlyByteBuf, VeinEntry> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.INT.fieldOf("x"), VeinEntry::x, (DualMapCodec)DualCodecs.INT.fieldOf("z"), VeinEntry::z, (DualMapCodec)DualCodecs.resourceKey((ResourceKey)Registries.DIMENSION).fieldOf("level"), VeinEntry::level, (DualMapCodec)HintedPosition.CODECS.listOf().fieldOf("hinted"), VeinEntry::hinted, VeinEntry::new);
    }
}

