/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockAdvancementTrigger;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.orientation.RotationUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class HammerItem
extends IEBaseItem {
    public HammerItem() {
        super(new Item.Properties().durability(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return IEServerConfig.getOrDefault(IEServerConfig.TOOLS.hammerDurabiliy);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, ctx, tooltip, flagIn);
        MultiblockRestriction permissions = (MultiblockRestriction)stack.getOrDefault(IEDataComponents.MULTIBLOCK_RESTRICTION, (Object)MultiblockRestriction.DEFAULT);
        this.addInfo(tooltip, "desc.immersiveengineering.info.multiblocksAllowed", permissions.allowed);
        this.addInfo(tooltip, "desc.immersiveengineering.info.multiblockForbidden", permissions.forbidden);
    }

    private void addInfo(List<Component> tooltip, String titleKey, Optional<List<ResourceLocation>> list) {
        if (list.isEmpty()) {
            return;
        }
        MutableComponent title = Component.translatable((String)titleKey);
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)title.append(" ").append((Component)Component.translatable((String)"desc.immersiveengineering.info.holdShift")));
        } else {
            tooltip.add((Component)title);
            for (ResourceLocation mbName : list.get()) {
                MultiblockHandler.IMultiblock multiblock = MultiblockHandler.getByUniqueName(mbName);
                if (multiblock == null) continue;
                tooltip.add((Component)TextUtils.applyFormat(multiblock.getDisplayName(), ChatFormatting.DARK_GRAY));
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        IEBlockInterfaces.IHammerInteraction hammerInteraction;
        boolean rotate;
        IEBlockInterfaces.IHammerBlockInteraction block;
        InteractionResult result;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        Direction side = context.getClickedFace();
        MultiblockRestriction restriction = (MultiblockRestriction)stack.getOrDefault(IEDataComponents.MULTIBLOCK_RESTRICTION, (Object)MultiblockRestriction.DEFAULT);
        Direction multiblockSide = side.getAxis() == Direction.Axis.Y && player != null ? Direction.fromYRot((double)player.getYRot()).getOpposite() : side;
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            boolean isAllowed;
            if (!mb.isBlockTrigger(world.getBlockState(pos), multiblockSide, world) || !(isAllowed = restriction.allowed.isPresent() ? restriction.allowed.get().contains(mb.getUniqueName()) : (restriction.forbidden.isPresent() ? !restriction.forbidden.get().contains(mb.getUniqueName()) : true)) || MultiblockHandler.postMultiblockFormationEvent(player, mb, pos, stack).isCanceled() || !mb.createStructure(world, pos, multiblockSide, player)) continue;
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                MultiblockAdvancementTrigger.INSTANCE.get().trigger(sPlayer, mb, stack);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IEBlockInterfaces.IConfigurableSides) {
            Direction activeSide;
            IEBlockInterfaces.IConfigurableSides sideConfig = (IEBlockInterfaces.IConfigurableSides)tile;
            Direction direction = activeSide = player != null && player.isShiftKeyDown() ? side.getOpposite() : side;
            if (sideConfig.toggleSide(activeSide, player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        Block activeSide = world.getBlockState(pos).getBlock();
        if (activeSide instanceof IEBlockInterfaces.IHammerBlockInteraction && (result = (block = (IEBlockInterfaces.IHammerBlockInteraction)activeSide).useHammer(world.getBlockState(pos), world, pos, player, context)).consumesAction()) {
            return result;
        }
        boolean bl = rotate = !(tile instanceof IEBlockInterfaces.IDirectionalBE) && !(tile instanceof IEBlockInterfaces.IHammerInteraction);
        if (!rotate && tile instanceof IEBlockInterfaces.IDirectionalBE) {
            IEBlockInterfaces.IDirectionalBE dirBE = (IEBlockInterfaces.IDirectionalBE)tile;
            rotate = dirBE.canHammerRotate(side, context.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos)), (LivingEntity)player);
        }
        if (rotate && RotationUtil.rotateBlock(world, pos, player != null && player.isShiftKeyDown() != side.equals((Object)Direction.DOWN))) {
            return InteractionResult.SUCCESS;
        }
        if (!rotate && tile instanceof IEBlockInterfaces.IHammerInteraction && (hammerInteraction = (IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, context.getHand(), context.getClickLocation())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private static List<ResourceLocation> parseMultiblockNames(ListTag data, @Nullable Player player, String prefix) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (int i = 0; i < data.size(); ++i) {
            String listEntry = data.getString(i);
            ResourceLocation asRL = ResourceLocation.tryParse((String)listEntry);
            if (asRL == null || MultiblockHandler.getByUniqueName(asRL) == null) {
                if (player != null && !player.getCommandSenderWorld().isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)("Invalid " + prefix + " entry: " + listEntry)), false);
                }
                return null;
            }
            result.add(asRL);
        }
        return result;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(@Nonnull ItemStack stack) {
        return ItemUtils.damageCopy(stack, 1);
    }

    public boolean hasCraftingRemainingItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 14;
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        ItemEnchantments enchantments = (ItemEnchantments)book.get(DataComponents.ENCHANTMENTS);
        return enchantments.keySet().stream().allMatch(HammerItem::canApplyAtEnchantingTable);
    }

    public static boolean canApplyAtEnchantingTable(Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.EFFICIENCY) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.MENDING);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Tags.Items.INGOTS_IRON);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!player.level().isClientSide && RotationUtil.rotateEntity((Entity)entity, player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.isCorrectToolForDrops(stack, state)) {
            return 6.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(IETags.hammerHarvestable);
    }

    public record MultiblockRestriction(Optional<List<ResourceLocation>> allowed, Optional<List<ResourceLocation>> forbidden) {
        public static final DualCodec<ByteBuf, MultiblockRestriction> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.RESOURCE_LOCATION.listOf().optionalFieldOf("allowed"), MultiblockRestriction::allowed, (DualMapCodec)DualCodecs.RESOURCE_LOCATION.listOf().optionalFieldOf("forbidden"), MultiblockRestriction::forbidden, MultiblockRestriction::new);
        public static final MultiblockRestriction DEFAULT = new MultiblockRestriction(Optional.empty(), Optional.empty());

        public MultiblockRestriction {
            if (allowed.isPresent()) {
                allowed = Optional.of(List.copyOf((Collection)allowed.get()));
            }
            if (forbidden.isPresent()) {
                forbidden = Optional.of(List.copyOf((Collection)forbidden.get()));
            }
        }
    }
}

