/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.upgrade.IUpgrade;
import blusunrize.immersiveengineering.api.tool.upgrade.IUpgradeableTool;
import blusunrize.immersiveengineering.common.gui.BlueprintInventory;
import blusunrize.immersiveengineering.common.gui.MaintenanceKitContainer;
import blusunrize.immersiveengineering.common.gui.ModWorkbenchContainer;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.inventory.EmptyContainer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class IESlot
extends Slot {
    final AbstractContainerMenu containerMenu;

    public IESlot(AbstractContainerMenu containerMenu, Container inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.containerMenu = containerMenu;
    }

    public boolean mayPlace(ItemStack itemStack) {
        return true;
    }

    public static interface ICallbackContainer {
        public boolean canInsert(ItemStack var1, int var2, Slot var3);

        public boolean canTake(ItemStack var1, int var2, Slot var3);
    }

    private static class SlotItemHandlerIE
    extends SlotItemHandler {
        public SlotItemHandlerIE(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int getMaxStackSize(@NotNull ItemStack stack) {
            return Math.min(Math.min(this.getMaxStackSize(), stack.getMaxStackSize()), super.getMaxStackSize(stack));
        }
    }

    public static class LogicCircuit
    extends SlotItemHandlerIE {
        public LogicCircuit(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return itemStack.getItem().equals((Object)IEItems.Misc.LOGIC_CIRCUIT_BOARD.get());
        }
    }

    public static class ContainerCallback
    extends SlotItemHandlerIE {
        ICallbackContainer container;

        public ContainerCallback(ICallbackContainer container, IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
            this.container = container;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return this.container.canInsert(itemStack, this.getSlotIndex(), (Slot)this);
        }

        public boolean mayPickup(Player player) {
            return this.container.canTake(this.getItem(), this.getSlotIndex(), (Slot)this);
        }
    }

    public static class AlwaysEmptySlot
    extends IESlot {
        public AlwaysEmptySlot(AbstractContainerMenu containerMenu) {
            super(containerMenu, EmptyContainer.INSTANCE, 0, 0, 0);
        }

        @Override
        public boolean mayPlace(ItemStack itemStack) {
            return false;
        }

        public boolean isActive() {
            return false;
        }
    }

    public static class Tagged
    extends SlotItemHandlerIE {
        private final TagKey<Item> tag;

        public Tagged(IItemHandler inv, int id, int x, int y, TagKey<Item> tag) {
            super(inv, id, x, y);
            this.tag = tag;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return itemStack.is(this.tag);
        }
    }

    public static class Cloche
    extends SlotItemHandlerIE {
        private final Level level;
        Type type;

        public Cloche(Type type, IItemHandler inv, int id, int x, int y, Level level) {
            super(inv, id, x, y);
            this.type = type;
            this.level = level;
        }

        public int getMaxStackSize() {
            return this.type != Type.FERTILIZER ? 1 : 64;
        }

        public boolean mayPlace(ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            if (this.type == Type.FERTILIZER) {
                return ClocheFertilizer.isValidFertilizer(this.level, itemStack);
            }
            IItemHandler inv = this.getItemHandler();
            if (this.type == Type.SOIL) {
                return ClocheRecipe.isValidCombinationInMenu(inv.getStackInSlot(1), itemStack, this.level);
            }
            if (this.type == Type.SEED) {
                return ClocheRecipe.isValidCombinationInMenu(itemStack, inv.getStackInSlot(0), this.level);
            }
            return true;
        }

        public static enum Type {
            SOIL,
            SEED,
            FERTILIZER;

        }
    }

    public static class ArcElectrode
    extends SlotItemHandlerIE {
        public ArcElectrode(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return ((Object)((Object)IEItems.Misc.GRAPHITE_ELECTRODE.get())).equals(itemStack.getItem());
        }
    }

    public static class ArcAdditive
    extends SlotItemHandlerIE {
        private final Level level;

        public ArcAdditive(IItemHandler inv, int id, int x, int y, Level level) {
            super(inv, id, x, y);
            this.level = level;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return !itemStack.isEmpty() && ArcFurnaceRecipe.isValidRecipeAdditive(this.level, itemStack);
        }
    }

    public static class ArcInput
    extends SlotItemHandlerIE {
        private final Level level;

        public ArcInput(IItemHandler inv, int id, int x, int y, Level level) {
            super(inv, id, x, y);
            this.level = level;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return !itemStack.isEmpty() && ArcFurnaceRecipe.isValidRecipeInput(this.level, itemStack);
        }
    }

    public static class BlueprintOutput
    extends IESlot {
        private final Container inputInventory;
        public final BlueprintCraftingRecipe recipe;

        public BlueprintOutput(ModWorkbenchContainer container, BlueprintInventory inv, Container inputInventory, int id, int x, int y, BlueprintCraftingRecipe recipe) {
            super(container, (Container)inv, id, x, y);
            this.inputInventory = inputInventory;
            this.recipe = recipe;
        }

        @Override
        public boolean mayPlace(ItemStack itemStack) {
            return false;
        }

        public boolean isOnPage() {
            return ((ModWorkbenchContainer)this.containerMenu).isOutputSlotOnPage(this);
        }

        public boolean isActive() {
            return this.hasItem() && this.isOnPage();
        }

        public boolean mayPickup(Player player) {
            return this.isOnPage();
        }

        public void onTake(Player player, ItemStack stack) {
            ((BlueprintInventory)this.container).reduceIputs(this.inputInventory, this.recipe, stack);
            super.onTake(player, stack);
        }
    }

    public static class BlueprintInput
    extends IESlot {
        private final BlueprintInventory outputInventory;

        public BlueprintInput(AbstractContainerMenu container, Container inv, BlueprintInventory outputInventory, int id, int x, int y) {
            super(container, inv, id, x, y);
            this.outputInventory = outputInventory;
        }

        public void setChanged() {
            this.outputInventory.updateOutputs(this.container);
            super.setChanged();
        }
    }

    public static class ItemDisplay
    extends IESlot {
        public ItemDisplay(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean mayPlace(ItemStack itemStack) {
            return false;
        }

        public boolean mayPickup(Player player) {
            return false;
        }
    }

    public static class ItemHandlerGhost
    extends SlotItemHandlerIE {
        public ItemHandlerGhost(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPickup(Player playerIn) {
            return false;
        }
    }

    public static class AutoBlueprint
    extends SlotItemHandlerIE {
        public AutoBlueprint(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean mayPlace(ItemStack itemStack) {
            return !itemStack.isEmpty() && itemStack.getItem() instanceof EngineersBlueprintItem;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public void setChanged() {
            super.setChanged();
            ImmersiveEngineering.proxy.reInitGui();
        }
    }

    public static class Maintenance
    extends IESlot {
        public Maintenance(MaintenanceKitContainer container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean mayPlace(ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            if (itemStack.getItem() instanceof IUpgradeableTool) {
                return ((IUpgradeableTool)itemStack.getItem()).canModify(itemStack);
            }
            if (itemStack.getItem() instanceof IConfigurableTool) {
                return ((IConfigurableTool)itemStack.getItem()).canConfigure(itemStack);
            }
            return false;
        }

        public void setChanged() {
            super.setChanged();
            if (this.containerMenu instanceof MaintenanceKitContainer) {
                ((MaintenanceKitContainer)this.containerMenu).updateSlots();
            }
        }

        public boolean mayPickup(Player player) {
            return this.getItem().isEmpty() || !(this.getItem().getItem() instanceof IUpgradeableTool) || ((IUpgradeableTool)this.getItem().getItem()).canTakeFromWorkbench(this.getItem());
        }

        public void onTake(Player player, ItemStack stack) {
            super.onTake(player, stack);
            if (!stack.isEmpty() && stack.getItem() instanceof IUpgradeableTool) {
                ((IUpgradeableTool)stack.getItem()).removeFromWorkbench(player, stack);
            }
        }
    }

    public static class ModWorkbench
    extends IESlot {
        int size;

        public ModWorkbench(ModWorkbenchContainer container, Container inv, int id, int x, int y, int size) {
            super(container, inv, id, x, y);
            this.size = size;
        }

        @Override
        public boolean mayPlace(ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            if (itemStack.getItem() instanceof EngineersBlueprintItem) {
                return true;
            }
            if (itemStack.getItem() instanceof IUpgradeableTool) {
                return ((IUpgradeableTool)itemStack.getItem()).canModify(itemStack);
            }
            if (itemStack.getItem() instanceof IConfigurableTool) {
                return ((IConfigurableTool)itemStack.getItem()).canConfigure(itemStack);
            }
            return false;
        }

        public int getMaxStackSize() {
            return this.size;
        }

        public void setChanged() {
            super.setChanged();
            AbstractContainerMenu abstractContainerMenu = this.containerMenu;
            if (abstractContainerMenu instanceof ModWorkbenchContainer) {
                ModWorkbenchContainer workbench = (ModWorkbenchContainer)abstractContainerMenu;
                workbench.rebindSlots();
            }
        }

        public boolean mayPickup(Player player) {
            IUpgradeableTool tool;
            Item item = this.getItem().getItem();
            return !(item instanceof IUpgradeableTool && !(tool = (IUpgradeableTool)item).canTakeFromWorkbench(this.getItem()));
        }

        public void onTake(Player player, ItemStack stack) {
            Item item;
            super.onTake(player, stack);
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof IUpgradeableTool) {
                IUpgradeableTool upgradeableTool = (IUpgradeableTool)item;
                upgradeableTool.removeFromWorkbench(player, stack);
            }
        }
    }

    public static class Shader
    extends IESlot {
        ItemStack tool;

        public Shader(AbstractContainerMenu container, Container inv, int id, int x, int y, ItemStack tool) {
            super(container, inv, id, x, y);
            this.tool = tool;
            this.setBackground(InventoryMenu.BLOCK_ATLAS, ImmersiveEngineering.rl("item/shader_slot"));
        }

        @Override
        public boolean mayPlace(ItemStack itemStack) {
            IShaderItem shaderItem;
            block5: {
                block4: {
                    Item item = itemStack.getItem();
                    if (!(item instanceof IShaderItem)) break block4;
                    shaderItem = (IShaderItem)item;
                    if (!this.tool.isEmpty()) break block5;
                }
                return false;
            }
            CapabilityShader.ShaderWrapper shaderCap = (CapabilityShader.ShaderWrapper)this.tool.getCapability(CapabilityShader.ITEM);
            if (shaderCap == null) {
                return false;
            }
            return ShaderRegistry.getShader(shaderItem.getShaderName(), shaderCap.getShaderType()) != null;
        }

        public int getMaxStackSize() {
            return 1;
        }
    }

    public static class Upgrades
    extends SlotItemHandlerIE {
        final ItemStack toolStack;
        private final IUpgradeableTool upgradeableTool;
        private final String type;
        private final boolean preventDoubles;
        private final AbstractContainerMenu container;
        private final Level world;
        private final Supplier<Player> getPlayer;

        public Upgrades(AbstractContainerMenu container, IItemHandler inv, int id, int x, int y, String type, ItemStack toolStack, boolean preventDoubles, Level world, Supplier<Player> getPlayer) {
            super(inv, id, x, y);
            this.container = container;
            this.type = type;
            this.toolStack = toolStack;
            this.upgradeableTool = (IUpgradeableTool)toolStack.getItem();
            this.preventDoubles = preventDoubles;
            this.world = world;
            this.getPlayer = getPlayer;
        }

        public boolean mayPlace(@Nonnull ItemStack itemStack) {
            IUpgrade upgrade;
            Item item;
            if (this.preventDoubles) {
                for (Slot slot : this.container.slots) {
                    if (this == slot || !(slot instanceof Upgrades) || !ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)itemStack)) continue;
                    return false;
                }
            }
            return !itemStack.isEmpty() && (item = itemStack.getItem()) instanceof IUpgrade && (upgrade = (IUpgrade)item).getUpgradeTypes(itemStack).contains(this.type) && upgrade.canApplyUpgrades(((IUpgradeableTool)this.toolStack.getItem()).getUpgrades(this.toolStack), itemStack);
        }

        public int getMaxStackSize() {
            return 64;
        }

        @Nonnull
        public ItemStack getItem() {
            return this.upgradeableTool.getUpgradeAfterRemoval(this.toolStack, super.getItem());
        }

        public void onTake(Player thePlayer, ItemStack stack) {
            if (!this.world.isClientSide) {
                this.upgradeableTool.removeUpgrade(this.toolStack, thePlayer, stack);
            }
            super.onTake(thePlayer, stack);
        }

        public void setChanged() {
            super.setChanged();
            if (!this.world.isClientSide) {
                this.upgradeableTool.recalculateUpgrades(this.toolStack, this.world, this.getPlayer.get());
                if (this.container instanceof ModWorkbenchContainer) {
                    ((ModWorkbenchContainer)this.container).rebindSlots();
                } else if (this.container instanceof MaintenanceKitContainer) {
                    ((MaintenanceKitContainer)this.container).updateSlots();
                }
            }
        }
    }

    public static class WithPredicate
    extends SlotItemHandlerIE {
        final Predicate<ItemStack> predicate;
        final Consumer<ItemStack> onChange;

        public WithPredicate(IItemHandler inv, int id, int x, int y, Predicate<ItemStack> predicate) {
            this(inv, id, x, y, predicate, s -> {});
        }

        public WithPredicate(IItemHandler inv, int id, int x, int y, Predicate<ItemStack> predicate, Consumer<ItemStack> onChange) {
            super(inv, id, x, y);
            this.predicate = predicate;
            this.onChange = onChange;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return !itemStack.isEmpty() && this.predicate.test(itemStack);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public void setChanged() {
            super.setChanged();
            this.onChange.accept(this.getItem());
        }
    }

    public static class Bullet
    extends SlotItemHandlerIE {
        int limit;

        public Bullet(IItemHandler inv, int id, int x, int y, int limit) {
            super(inv, id, x, y);
            this.limit = limit;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return !itemStack.isEmpty() && itemStack.getItem() instanceof BulletItem;
        }

        public int getMaxStackSize() {
            return this.limit;
        }
    }

    public static class BlastFuel
    extends SlotItemHandlerIE {
        private final Level level;

        public BlastFuel(IItemHandler inv, int id, int x, int y, Level level) {
            super(inv, id, x, y);
            this.level = level;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return BlastFurnaceFuel.isValidBlastFuel(this.level, itemStack);
        }
    }

    public static class FluidContainer
    extends IESlot {
        int filter;

        public FluidContainer(AbstractContainerMenu container, Container inv, int id, int x, int y, int filter) {
            super(container, inv, id, x, y);
            this.filter = filter;
        }

        @Override
        public boolean mayPlace(ItemStack itemStack) {
            IFluidHandlerItem handler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
            if (handler == null) {
                return false;
            }
            if (handler.getTanks() <= 0) {
                return false;
            }
            if (this.filter == 1) {
                return handler.getFluidInTank(0).isEmpty();
            }
            if (this.filter == 2) {
                return !handler.getFluidInTank(0).isEmpty();
            }
            return true;
        }
    }

    public static class NewFluidContainer
    extends SlotItemHandlerIE {
        private final Filter filter;

        public NewFluidContainer(IItemHandler inv, int id, int x, int y, Filter filter) {
            super(inv, id, x, y);
            this.filter = filter;
        }

        public boolean mayPlace(ItemStack itemStack) {
            IFluidHandlerItem handler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
            if (handler == null) {
                return false;
            }
            if (handler.getTanks() <= 0) {
                return false;
            }
            return switch (this.filter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> handler.getFluidInTank(0).isEmpty();
                case 2 -> !handler.getFluidInTank(0).isEmpty();
            };
        }

        public static enum Filter {
            ANY,
            EMPTY,
            FULL;

        }
    }

    public static class IEFurnaceSFuelSlot
    extends SlotItemHandlerIE {
        public IEFurnaceSFuelSlot(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return AbstractFurnaceBlockEntity.isFuel((ItemStack)stack) || IEFurnaceSFuelSlot.isBucket(stack);
        }

        @Override
        public int getMaxStackSize(@NotNull ItemStack stack) {
            return IEFurnaceSFuelSlot.isBucket(stack) ? 1 : super.getMaxStackSize(stack);
        }

        public static boolean isBucket(ItemStack stack) {
            return stack.getItem() == Items.BUCKET;
        }
    }

    public static class NewOutput
    extends SlotItemHandlerIE {
        public NewOutput(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean mayPlace(ItemStack itemStack) {
            return false;
        }
    }

    public static class Output
    extends IESlot {
        public Output(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean mayPlace(ItemStack itemStack) {
            return false;
        }
    }
}

