/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FermenterLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FermenterMenu
extends IEContainerMenu {
    public final EnergyStorage energyStorage;
    public final FluidTank tank;

    public static FermenterMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<FermenterLogic.State> ctx) {
        FermenterLogic.State state = ctx.mbContext().getState();
        return new FermenterMenu(FermenterMenu.multiblockCtx(type, id, ctx), invPlayer, (IItemHandler)state.getInventory(), state.getEnergy(), state.getTank());
    }

    public static FermenterMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new FermenterMenu(FermenterMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(11), new MutableEnergyStorage(16000), new FluidTank(24000));
    }

    private FermenterMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, MutableEnergyStorage energyStorage, FluidTank tank) {
        super(ctx);
        int i;
        this.energyStorage = energyStorage;
        this.tank = tank;
        for (i = 0; i < 8; ++i) {
            this.addSlot((Slot)new SlotItemHandler(inv, i, 8 + i % 4 * 18, 19 + i / 4 * 18));
        }
        this.addSlot((Slot)new IESlot.NewOutput(inv, 8, 91, 53));
        this.addSlot((Slot)new IESlot.NewFluidContainer(inv, 9, 134, 17, IESlot.NewFluidContainer.Filter.ANY));
        this.addSlot((Slot)new IESlot.NewOutput(inv, 10, 134, 53));
        this.ownSlotCount = 11;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 143));
        }
        this.addGenericData(GenericContainerData.energy(energyStorage));
        this.addGenericData(GenericContainerData.fluid(tank));
    }
}

