/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AutoWorkbenchLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AutoWorkbenchMenu
extends IEContainerMenu {
    public final EnergyStorage energyStorage;
    public final GetterAndSetter<Integer> selectedRecipe;

    public static AutoWorkbenchMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<AutoWorkbenchLogic.State> ctx) {
        AutoWorkbenchLogic.State state = ctx.mbContext().getState();
        return new AutoWorkbenchMenu(AutoWorkbenchMenu.multiblockCtx(type, id, ctx), invPlayer, (IItemHandler)state.inventory, state.getEnergy(), new GetterAndSetter<Integer>(() -> state.selectedRecipe, i -> {
            state.selectedRecipe = i;
        }));
    }

    public static AutoWorkbenchMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new AutoWorkbenchMenu(AutoWorkbenchMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(17), new MutableEnergyStorage(32000), GetterAndSetter.standalone(0));
    }

    private AutoWorkbenchMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, MutableEnergyStorage energyStorage, GetterAndSetter<Integer> selectedRecipe) {
        super(ctx);
        this.energyStorage = energyStorage;
        this.selectedRecipe = selectedRecipe;
        this.addSlot((Slot)new IESlot.AutoBlueprint(inv, 0, 102, 69));
        for (int i = 0; i < 16; ++i) {
            this.addSlot((Slot)new SlotItemHandler(inv, 1 + i, 7 + i % 4 * 18, 24 + i / 4 * 18));
        }
        this.ownSlotCount = 17;
        this.bindPlayerInv(inventoryPlayer);
        this.addGenericData(GenericContainerData.energy(energyStorage));
        this.addGenericData(new GenericContainerData<Integer>(GenericDataSerializers.INT32, selectedRecipe));
    }

    private void bindPlayerInv(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 103 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 161));
        }
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.slots.get(slot);
        if (slotObject != null && slotObject.hasItem()) {
            ItemStack stackInSlot = slotObject.getItem();
            stack = stackInSlot.copy();
            if (slot < this.ownSlotCount) {
                if (!this.moveItemStackTo(stackInSlot, this.ownSlotCount, this.ownSlotCount + 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!stackInSlot.isEmpty()) {
                if (stackInSlot.getItem() instanceof EngineersBlueprintItem) {
                    if (!this.moveItemStackTo(stackInSlot, 0, 1, true)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    boolean b = true;
                    for (int i = 1; i < this.ownSlotCount; ++i) {
                        Slot s = (Slot)this.slots.get(i);
                        if (s == null || !s.mayPlace(stackInSlot) || !this.moveItemStackTo(stackInSlot, i, i + 1, true)) continue;
                        b = false;
                        break;
                    }
                    if (b) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (stackInSlot.getCount() == 0) {
                slotObject.set(ItemStack.EMPTY);
            } else {
                slotObject.setChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slotObject.onTake(player, stack);
        }
        return stack;
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        if (nbt.contains("recipe", 3)) {
            this.selectedRecipe.set(nbt.getInt("recipe"));
        }
    }
}

