/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.energy.WindmillBiome;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.utils.codec.IEStreamCodecs;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;

public class WindmillBiomeSerializer
extends IERecipeSerializer<WindmillBiome> {
    public static final MapCodec<WindmillBiome> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.FLOAT.fieldOf("modifier").forGetter(r -> Float.valueOf(r.modifier)), (App)TagKey.codec((ResourceKey)Registries.BIOME).optionalFieldOf("biomeTag").forGetter(r -> r.biomes.leftOptional()), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).listOf().optionalFieldOf("singleBiome").forGetter(r -> r.biomes.rightOptional())).apply((Applicative)inst, (temperature, tag, fixedBiomes) -> {
        Preconditions.checkState((tag.isPresent() != fixedBiomes.isPresent() ? 1 : 0) != 0);
        if (tag.isPresent()) {
            return new WindmillBiome((TagKey<Biome>)((TagKey)tag.get()), temperature.floatValue());
        }
        return new WindmillBiome((List)fixedBiomes.get(), temperature.floatValue());
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, WindmillBiome> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either(IEStreamCodecs.tagCodec(Registries.BIOME), (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.BIOME).apply(ByteBufCodecs.list())), r -> r.biomes.toDFU(), (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.modifier), (e, m) -> new WindmillBiome(FastEither.fromDFU(e), m.floatValue()));
    public static final DualMapCodec<RegistryFriendlyByteBuf, WindmillBiome> CODECS = new DualMapCodec(CODEC, STREAM_CODEC);

    @Override
    protected DualMapCodec<RegistryFriendlyByteBuf, WindmillBiome> codecs() {
        return CODECS;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.WoodenDevices.WINDMILL);
    }
}

