/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.components.AttachedItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EarmuffsRecipe
implements CraftingRecipe {
    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingInput inv, @Nonnull Level worldIn) {
        ItemStack earmuffs = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ArmorItem armorItem;
            Item item;
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            boolean isEarmuffs = stackInSlot.is(IEItems.Misc.EARMUFFS.asItem());
            if (earmuffs.isEmpty() && isEarmuffs) {
                earmuffs = stackInSlot;
                continue;
            }
            if (armor.isEmpty() && (item = stackInSlot.getItem()) instanceof ArmorItem && (armorItem = (ArmorItem)item).getEquipmentSlot() == EquipmentSlot.HEAD && !isEarmuffs) {
                armor = stackInSlot;
                continue;
            }
            return false;
        }
        if (armor.isEmpty()) {
            return false;
        }
        boolean addingEarmuffs = !earmuffs.isEmpty();
        boolean removingEarmuffs = armor.has(IEDataComponents.CONTAINED_EARMUFF);
        return addingEarmuffs != removingEarmuffs;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        ItemStack earmuffs = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            boolean isEarmuffs = stackInSlot.is(IEItems.Misc.EARMUFFS.asItem());
            if (earmuffs.isEmpty() && isEarmuffs) {
                earmuffs = stackInSlot;
                continue;
            }
            if (!armor.isEmpty() || !(stackInSlot.getItem() instanceof ArmorItem) || ((ArmorItem)stackInSlot.getItem()).getEquipmentSlot() != EquipmentSlot.HEAD || isEarmuffs) continue;
            armor = stackInSlot;
        }
        if (!earmuffs.isEmpty()) {
            ItemStack output;
            if (!armor.isEmpty()) {
                output = armor.copy();
                output.set(IEDataComponents.CONTAINED_EARMUFF, (Object)new AttachedItem(earmuffs));
            } else {
                output = earmuffs.copy();
            }
            return output;
        }
        if (!armor.isEmpty() && armor.has(IEDataComponents.CONTAINED_EARMUFF)) {
            ItemStack output = armor.copy();
            output.remove(IEDataComponents.CONTAINED_EARMUFF);
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider access) {
        return new ItemStack(IEItems.Misc.EARMUFFS, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList remaining = super.getRemainingItems((RecipeInput)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            AttachedItem earmuffs = (AttachedItem)stackInSlot.get(IEDataComponents.CONTAINED_EARMUFF);
            if (earmuffs == null) continue;
            remaining.set(i, (Object)earmuffs.attached());
        }
        return remaining;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.EARMUFF_SERIALIZER.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.withSize((int)1, (Object)Ingredient.of((ItemLike[])new ItemLike[]{IEItems.Misc.EARMUFFS}));
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }
}

