/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcRecyclingChecker;
import blusunrize.immersiveengineering.api.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class ArcRecyclingCalculator {
    private final List<RecipeHolder<?>> recipeList;
    private final long startTime;
    private final ArcRecyclingChecker checker;
    private final RegistryAccess tags;

    public ArcRecyclingCalculator(Collection<RecipeHolder<?>> allRecipes, RegistryAccess tags) {
        this.tags = tags;
        this.startTime = System.currentTimeMillis();
        Pair<Predicate<Recipe<?>>, ArcRecyclingChecker> pair = ArcRecyclingChecker.assembleRecyclingFilter(tags);
        this.checker = (ArcRecyclingChecker)pair.getSecond();
        this.recipeList = allRecipes.stream().filter(r -> ((Predicate)pair.getFirst()).test(r.value())).collect(Collectors.toList());
    }

    public List<ArcFurnaceRecipe> run() {
        RecipeIterator iterator = new RecipeIterator(this.recipeList, this.checker, this.tags);
        iterator.process();
        int timeout = 0;
        while (!iterator.nonValidated.isEmpty() && timeout++ < iterator.invalidCount * 10) {
            ArrayList<RecyclingCalculation> newlyValid = new ArrayList<RecyclingCalculation>();
            for (RecyclingCalculation valid : iterator.validated) {
                for (ItemStack key : iterator.nonValidated.keySet()) {
                    if (!ItemStack.isSameItem((ItemStack)key, (ItemStack)valid.stack)) continue;
                    for (RecyclingCalculation nonValid : iterator.nonValidated.get((Object)key)) {
                        if (!nonValid.validateSubcomponent(valid)) continue;
                        newlyValid.add(nonValid);
                    }
                }
            }
            if (newlyValid.isEmpty()) break;
            iterator.nonValidated.values().removeAll(newlyValid);
            iterator.validated.addAll(newlyValid);
        }
        ArrayList<ArcFurnaceRecipe> generatedRecipes = new ArrayList<ArcFurnaceRecipe>();
        HashSet<String> finishedRecycles = new HashSet<String>();
        for (RecyclingCalculation valid : iterator.validated) {
            if (!finishedRecycles.add(valid.stack.toString()) || valid.outputs.isEmpty()) continue;
            generatedRecipes.add(this.makeRecipe(valid));
        }
        for (RecyclingCalculation invalid : Sets.newHashSet((Iterable)iterator.nonValidated.values())) {
            if (!finishedRecycles.add(invalid.stack.toString()) || invalid.outputs.isEmpty()) continue;
            IELogger.info("Couldn't fully analyze " + String.valueOf(invalid.stack) + ", missing knowledge for " + String.valueOf(invalid.queriedSubcomponents));
            generatedRecipes.add(this.makeRecipe(invalid));
        }
        IELogger.info("Finished recipe profiler for Arc Recycling, took " + (System.currentTimeMillis() - this.startTime) + " milliseconds");
        return generatedRecipes;
    }

    public static Mutable<List<ArcFurnaceRecipe>> makeFuture() {
        MutableObject result = new MutableObject();
        MutableObject eventListener = new MutableObject();
        eventListener.setValue(new Object((Mutable)result, (Mutable)eventListener){
            final /* synthetic */ Mutable val$result;
            final /* synthetic */ Mutable val$eventListener;
            {
                this.val$result = mutable;
                this.val$eventListener = mutable2;
            }

            @SubscribeEvent
            public void onServerStarted(ServerStartedEvent ev) {
                this.fillInRecipes(ev.getServer());
            }

            @SubscribeEvent
            public void onServerTick(ServerTickEvent.Pre ev) {
                this.fillInRecipes(ServerLifecycleHooks.getCurrentServer());
            }

            @SubscribeEvent
            public void onDatapackSync(OnDatapackSyncEvent ev) {
                this.fillInRecipes(ev.getPlayerList().getServer());
            }

            private void fillInRecipes(MinecraftServer server) {
                if (this.val$result.getValue() == null) {
                    NeoForge.EVENT_BUS.unregister(this.val$eventListener.getValue());
                    Collection recipes = server.getRecipeManager().getRecipes();
                    ArcRecyclingCalculator calculator = new ArcRecyclingCalculator(recipes, (RegistryAccess)server.registryAccess());
                    this.val$result.setValue(calculator.run());
                }
            }
        });
        NeoForge.EVENT_BUS.register(eventListener.getValue());
        return result;
    }

    private ArcRecyclingRecipe makeRecipe(RecyclingCalculation calculation) {
        return new ArcRecyclingRecipe(() -> this.tags, calculation.outputs.entrySet().stream().map(e -> Pair.of((Object)new TagOutput((ItemStack)e.getKey()), (Object)((Double)e.getValue()))).toList(), IngredientWithSize.of(calculation.stack), 100, 51200);
    }

    private static class RecipeIterator {
        final List<RecipeHolder<?>> recipeList;
        final List<RecyclingCalculation> validated = new ArrayList<RecyclingCalculation>();
        final Multimap<ItemStack, RecyclingCalculation> nonValidated = ArrayListMultimap.create();
        private final ArcRecyclingChecker checker;
        int invalidCount = 0;
        private final RegistryAccess tags;

        public RecipeIterator(List<RecipeHolder<?>> recipeList, ArcRecyclingChecker checker, RegistryAccess tags) {
            this.recipeList = recipeList;
            this.checker = checker;
            this.tags = tags;
        }

        public void process() {
            for (RecipeHolder<?> recipe : this.recipeList) {
                RecyclingCalculation calc = this.getRecycleCalculation(recipe.value().getResultItem((HolderLookup.Provider)this.tags), recipe);
                if (calc == null) continue;
                if (calc.isValid()) {
                    this.validated.add(calc);
                    continue;
                }
                for (ItemStack s : calc.queriedSubcomponents.keySet()) {
                    this.nonValidated.put((Object)s, (Object)calc);
                }
                ++this.invalidCount;
            }
        }

        private RecyclingCalculation getRecycleCalculation(ItemStack stack, RecipeHolder<?> recipe) {
            Pair<ItemStack, Double> brokenDown = ApiUtils.breakStackIntoPreciseIngots(this.tags, stack);
            if (brokenDown != null && ArcRecyclingChecker.isValidRecyclingOutput(this.tags, (ItemStack)brokenDown.getFirst()) && (Double)brokenDown.getSecond() > 0.0) {
                return new RecyclingCalculation(recipe.value(), stack.copyWithCount(1), (Map<ItemStack, Double>)ImmutableMap.of((Object)((ItemStack)brokenDown.getFirst()), (Object)((Double)brokenDown.getSecond())));
            }
            NonNullList inputs = recipe.value().getIngredients();
            if (!inputs.isEmpty()) {
                int resultCount = stack.getCount();
                HashMap<ItemStack, Integer> missingSub = new HashMap<ItemStack, Integer>();
                IdentityHashMap<ItemStack, Double> outputs = new IdentityHashMap<ItemStack, Double>();
                for (Object in : inputs) {
                    boolean invalidOutput;
                    if (in == null || in == Ingredient.EMPTY) continue;
                    ItemStack[] itemStackArray = in.getItems();
                    ItemStack inputStack = ItemStack.EMPTY;
                    if (itemStackArray.length > 0) {
                        inputStack = IEApi.getPreferredStackbyMod(in.getItems());
                    }
                    if (inputStack.isEmpty()) {
                        IELogger.warn("Recipe has invalid inputs and will be ignored: " + String.valueOf(recipe) + " (" + String.valueOf(recipe.id()) + ")");
                        return null;
                    }
                    brokenDown = ApiUtils.breakStackIntoPreciseIngots(this.tags, inputStack);
                    if (brokenDown == null) {
                        if (!this.checker.isAllowed(this.tags, inputStack) || !ArcRecyclingChecker.isValidRecyclingOutput(this.tags, inputStack)) continue;
                        boolean b = false;
                        for (ItemStack storedMiss : missingSub.keySet()) {
                            if (!ItemStack.isSameItem((ItemStack)inputStack, (ItemStack)storedMiss)) continue;
                            missingSub.put(storedMiss, (Integer)missingSub.get(storedMiss) + inputStack.getCount());
                            b = true;
                        }
                        if (b) continue;
                        missingSub.put(inputStack.copyWithCount(1), inputStack.getCount());
                        continue;
                    }
                    if (((ItemStack)brokenDown.getFirst()).isEmpty() || !((Double)brokenDown.getSecond() > 0.0) || (invalidOutput = !ArcRecyclingChecker.isValidRecyclingOutput(this.tags, (ItemStack)brokenDown.getFirst()))) continue;
                    boolean b = false;
                    for (ItemStack storedOut : outputs.keySet()) {
                        if (!ItemStack.isSameItem((ItemStack)((ItemStack)brokenDown.getFirst()), (ItemStack)storedOut)) continue;
                        outputs.put(storedOut, (Double)outputs.get(storedOut) + (Double)brokenDown.getSecond());
                        b = true;
                    }
                    if (b) continue;
                    outputs.put(((ItemStack)brokenDown.getFirst()).copyWithCount(1), (Double)brokenDown.getSecond());
                }
                IdentityHashMap<ItemStack, Double> outputScaled = new IdentityHashMap<ItemStack, Double>(outputs.size());
                for (Map.Entry entry : outputs.entrySet()) {
                    outputScaled.put((ItemStack)entry.getKey(), (Double)entry.getValue() / (double)resultCount);
                }
                if (!outputs.isEmpty() || !missingSub.isEmpty()) {
                    Object in;
                    in = stack.copyWithCount(1);
                    RecyclingCalculation recyclingCalculation = new RecyclingCalculation(recipe.value(), (ItemStack)in, outputScaled);
                    if (!missingSub.isEmpty()) {
                        for (ItemStack s : missingSub.keySet()) {
                            recyclingCalculation.queriedSubcomponents.put(s, (double)((Integer)missingSub.get(s)).intValue() / (double)resultCount);
                        }
                    }
                    return recyclingCalculation;
                }
            }
            return null;
        }
    }

    private static class RecyclingCalculation {
        Recipe<?> recipe;
        ItemStack stack;
        Map<ItemStack, Double> outputs;
        Map<ItemStack, Double> queriedSubcomponents = new HashMap<ItemStack, Double>();

        public RecyclingCalculation(Recipe<?> recipe, ItemStack stack, Map<ItemStack, Double> outputs) {
            this.recipe = recipe;
            this.stack = stack;
            this.outputs = outputs;
        }

        public boolean isValid() {
            return !this.outputs.isEmpty() && this.queriedSubcomponents.isEmpty();
        }

        public boolean validateSubcomponent(RecyclingCalculation calc) {
            if (this.isValid()) {
                return true;
            }
            if (!calc.isValid()) {
                return false;
            }
            Iterator<ItemStack> it = this.queriedSubcomponents.keySet().iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!ItemStack.isSameItem((ItemStack)next, (ItemStack)calc.stack)) continue;
                double queriedAmount = this.queriedSubcomponents.get(next);
                for (Map.Entry<ItemStack, Double> e : calc.outputs.entrySet()) {
                    double scaledVal = e.getValue() * queriedAmount;
                    boolean b = true;
                    for (ItemStack key : this.outputs.keySet()) {
                        if (!ItemStack.isSameItem((ItemStack)key, (ItemStack)e.getKey())) continue;
                        this.outputs.put(key, this.outputs.get(key) + scaledVal);
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    this.outputs.put(e.getKey(), scaledVal);
                }
                it.remove();
            }
            return this.isValid();
        }
    }
}

